/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.dao.impl;

import java.util.ArrayList;
import java.util.List;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.ObjectNodeDao;
import jp.sf.pal.cms.dto.FileNodeDto;
import jp.sf.pal.cms.dto.FolderNodeDto;
import jp.sf.pal.cms.util.CMSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.jcr.SessionFactory;

/**
 * @author shinsuke
 * 
 */
public class ObjectNodeDaoImpl implements ObjectNodeDao {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ObjectNodeDaoImpl.class);

    private SessionFactory sessionFactory_;

    private S2Container container;

    public ObjectNodeDaoImpl(SessionFactory sessionFactory) {
        sessionFactory_ = sessionFactory;
    }

    public List getObjectNodes(String scopeName, String path)
            throws CMSException {
        StringBuffer q = new StringBuffer(CMSConstants.PATH_SEPARATOR
                + CMSConstants.PATH_SEPARATOR + CMSConstants.SCOPE_NODE + "[@"
                + CMSConstants.SCOPE_NODE_NAME_ATTR + " = '"
                + CMSUtil.escapeAttributeValue(scopeName) + "']");

        String[] nodes = path.split(CMSConstants.PATH_SEPARATOR);
        for (int i = 1; i < nodes.length; i++) {
            q.append(CMSConstants.PATH_SEPARATOR + CMSConstants.FOLDER_NODE
                    + "[@" + CMSConstants.FOLDER_NODE_NAME_ATTR + "='"
                    + CMSUtil.escapeAttributeValue(nodes[i]) + "']");
        }
        q.append(CMSConstants.PATH_SEPARATOR + "*");
        if (log.isDebugEnabled()) {
            log.debug("getFileNodes(String, String) - q=" + q);
        }

        try {
            Query query = sessionFactory_.getSession().getWorkspace()
                    .getQueryManager().createQuery(q.toString(), Query.XPATH);
            QueryResult result = query.execute();
            NodeIterator ni = result.getNodes();
            List list = new ArrayList();
            while (ni.hasNext()) {
                Node node = ni.nextNode();
                if (log.isDebugEnabled()) {
                    // TODO remove this log
                    log.debug("getFileNodes(String, String) - node.getName()="
                            + node.getName());
                }
                if (node.getName().equals(CMSConstants.FILE_NODE)) {
                    FileNodeDto fileNodeDto = (FileNodeDto) container
                            .getComponent(FileNodeDto.class);
                    // FileNodeDto fileNode = new FileNodeDto();
                    fileNodeDto.setScope(scopeName);
                    fileNodeDto.setParentPath(path);
                    fileNodeDto.setName(node.getProperty(
                            CMSConstants.FILE_NODE_NAME_ATTR).getString());

                    // TODO check node type
                    // Node contentNode =
                    // node.getNode(CMSConstants.CONTENT_NODE);
                    Node contentNode = node
                            .getNode(CMSConstants.AUTHORING_CONTENT_NODE);

                    fileNodeDto.setTitle(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_TITLE_ATTR).getString());
                    fileNodeDto.setDescription(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_DESCRIPTION_ATTR)
                            .getString());
                    fileNodeDto.setMimeType(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_MIMETYPE_ATTR)
                            .getString());
                    fileNodeDto.setEncoding(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_ENCODING_ATTR)
                            .getString());
                    fileNodeDto.setInputStream(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_DATA_ATTR).getStream());
                    fileNodeDto.setCreatedTime(node.getProperty(
                            CMSConstants.FILE_NODE_CREATED_ATTR).getDate());
                    fileNodeDto.setLastModifiedTime(contentNode.getProperty(
                            CMSConstants.CONTENT_NODE_LASTMODIFIED_ATTR)
                            .getDate());

                    list.add(fileNodeDto);
                } else if (node.getName().equals(CMSConstants.FOLDER_NODE)) {
                    FolderNodeDto folderNode = (FolderNodeDto) container
                            .getComponent(FolderNodeDto.class);
                    // FolderNodeDto folderNode = new FolderNodeDto();
                    folderNode.setScope(scopeName);
                    folderNode.setParentPath(path);
                    folderNode.setName(node.getProperty(
                            CMSConstants.FOLDER_NODE_NAME_ATTR).getString());
                    list.add(folderNode);
                } else {
                    log.warn("Undefined object:" + node);
                }
            }
            return list;
        } catch (InvalidQueryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ItemExistsException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (PathNotFoundException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (VersionException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (LockException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ValueFormatException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (RepositoryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        }
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

}
