/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.webparts;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebPartsPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)WebPartsPortlet.class);
    public static final String TITLE = "jp.sf.pal.webparts.Title";
    public static final String CODE = "jp.sf.pal.webparts.Code";
    public static final String URL = "jp.sf.pal.webparts.Url";
    public static final String VIEW_PAGE = "jp.sf.pal.webparts.ViewPage";
    public static final String EDIT_PAGE = "jp.sf.pal.webparts.EditPage";
    public static final String MESSAGE = "jp.sf.pal.webparts.Message";
    public static final String DEFAULT_VIEW_VALUE = "/WEB-INF/jsp/view.jsp";
    public static final String DEFAULT_EDIT_VALUE = "/WEB-INF/jsp/edit.jsp";
    private String defaultTitle = "";
    private String defaultCode = "";
    private String defaultUrl = "";
    private String defaultViewPage = "";
    private String defaultEditPage = "";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.defaultTitle = config.getInitParameter(TITLE);
        this.defaultCode = config.getInitParameter(CODE);
        this.defaultUrl = config.getInitParameter(URL);
        this.defaultViewPage = config.getInitParameter(VIEW_PAGE);
        if (this.defaultViewPage == null) {
            this.defaultViewPage = DEFAULT_VIEW_VALUE;
        }
        this.defaultEditPage = config.getInitParameter(EDIT_PAGE);
        if (this.defaultEditPage == null) {
            this.defaultEditPage = DEFAULT_EDIT_VALUE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init(PortletConfig) - defaultTitle=" + this.defaultTitle));
            log.debug((Object)("init(PortletConfig) - defaultCode=" + this.defaultCode));
            log.debug((Object)("init(PortletConfig) - defaultUrl=" + this.defaultUrl));
            log.debug((Object)("init(PortletConfig) - defaultViewPage=" + this.defaultViewPage));
            log.debug((Object)("init(PortletConfig) - defaultEditPage=" + this.defaultEditPage));
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"doView(RenderRequest, RenderResponse)");
        }
        String viewPage = this.defaultViewPage;
        this.renderView(request, response, viewPage);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"doEdit(RenderRequest, RenderResponse)");
        }
        String viewPage = this.defaultEditPage;
        String msg = request.getParameter(MESSAGE);
        if (msg == null) {
            msg = "";
        }
        request.setAttribute(MESSAGE, (Object)msg);
        PortletPreferences prefs = request.getPreferences();
        request.setAttribute(TITLE, (Object)prefs.getValue(TITLE, this.defaultTitle));
        request.setAttribute(URL, (Object)prefs.getValue(URL, this.defaultUrl));
        this.renderView(request, response, viewPage);
    }

    protected void renderView(RenderRequest request, RenderResponse response, String viewPage) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderView(RenderRequest, RenderResponse, String) - viewPage=" + viewPage));
        }
        response.setContentType("text/html");
        PortletContext context = this.getPortletContext();
        PortletPreferences prefs = request.getPreferences();
        response.setTitle(prefs.getValue(TITLE, this.defaultTitle));
        request.setAttribute(CODE, (Object)prefs.getValue(CODE, this.defaultCode));
        PortletRequestDispatcher rd = context.getRequestDispatcher(viewPage);
        rd.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processAction(ActionRequest, ActionResponse) - request.getPortletMode()=" + request.getPortletMode()));
        }
        if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            String urlValue;
            String titleValue;
            String codeValue = request.getParameter(CODE);
            if (codeValue == null) {
                codeValue = "";
            }
            if ((titleValue = request.getParameter(TITLE)) == null) {
                titleValue = "";
            }
            if ((urlValue = request.getParameter(URL)) == null) {
                urlValue = "";
            }
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(CODE, codeValue);
            prefs.setValue(TITLE, titleValue);
            prefs.setValue(URL, urlValue);
            prefs.store();
            ResourceBundle bundle = this.getPortletConfig().getResourceBundle(request.getLocale());
            response.setRenderParameter(MESSAGE, bundle.getString("WebPartsPortlet.msg.Updated"));
        }
    }
}

