/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class FormatDateFunction
extends SimpleNode {
    public FormatDateFunction(int id) {
        super(id);
    }

    public FormatDateFunction(Parser p, int id) {
        super(p, id);
    }

    public String toNormalizedString() {
        String normalized = "";
        normalized = "format-date(" + this.jjtGetChild(0).toNormalizedString() + this.jjtGetChild(1).toNormalizedString() + "," + ")";
        return normalized;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        String formatted;
        try {
            DateFormat form;
            JSPDate arg = Convert.toJSPDate(this.jjtGetChild(0).evaluate(pageContext, icontext));
            String pattern = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, icontext));
            if (this.jjtGetNumChildren() > 2) {
                String arg3 = Convert.toString(this.jjtGetChild(2).evaluate(pageContext, icontext));
                Locale locale = this.getLocale(arg3);
                form = DateFormat.getDateInstance(2, locale);
            } else {
                form = DateFormat.getInstance();
            }
            try {
                ((SimpleDateFormat)form).applyPattern(pattern);
                formatted = form.format(new Date(arg.getTime().longValue()));
            }
            catch (IllegalArgumentException iae) {
                formatted = new String("");
            }
        }
        catch (ConversionException ce) {
            throw new EvaluationException(this, ce.getMessage());
        }
        return formatted;
    }

    private Locale getLocale(String arg) {
        Locale result;
        StringTokenizer st = new StringTokenizer(arg, "_");
        String language = null;
        String country = null;
        String variant = null;
        if (st.hasMoreTokens()) {
            language = st.nextToken();
            if (st.hasMoreTokens()) {
                country = st.nextToken();
                if (st.hasMoreTokens()) {
                    variant = st.nextToken();
                    result = new Locale(language, country, variant);
                } else {
                    result = new Locale(language, country);
                }
            } else {
                result = new Locale(language, "");
            }
        } else {
            result = Locale.getDefault();
        }
        return result;
    }
}

