/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.jsf.custom.fileupload;

import javax.faces.component.ComponentUtil_;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;

import jp.sf.pal.jsf.JsfConstants;

public class HtmlInputFileUpload extends HtmlInputText {
    public static final String COMPONENT_TYPE = "jp.sf.pal.jsf.HtmlInputFileUpload";

    public static final String DEFAULT_RENDERER_TYPE = "jp.sf.pal.jsf.FileUpload";

    public static final String SIZE_LIMIT_MESSAGE_ID = "jp.sf.pal.jsf.FileUpload.SIZE_LIMIT";

    private String accept = null;

    private String storage = null;

    public HtmlInputFileUpload() {
        setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setUploadedFile(UploadedFile upFile) {
        setValue(upFile);
    }

    public UploadedFile getUploadedFile() {
        return (UploadedFile) getValue();
    }

    public String getStorage() {
        if (storage != null) {
            return storage;
        }
        return ComponentUtil_.getValueBindingValueAsString(this,
                JsfConstants.STORAGE_ATTR);
    }

    public void setStorage(String storage) {
      this.  storage = storage;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        if (accept != null) {
            return accept;
        }
        return ComponentUtil_.getValueBindingValueAsString(this,
                JsfConstants.ACCEPT_ATTR);
    }

    public boolean isRendered() {
        return super.isRendered();
    }

    public Object saveState(FacesContext context) {
        Object values[] = new Object[5];
        values[0] = super.saveState(context);
        values[1] = accept;
        values[2] = storage;
        return ((Object) (values));
    }

    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        accept = (String) values[1];
        storage = (String) values[2];
    }
}
