/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.pager;

import jp.sf.pal.admin.PALAdminConstants;

public class DefaultPager implements Pager
{

    private int offset;

    private int count;

    private int limit;

    public DefaultPager()
    {
        super();
        setOffset(0);
        setCount(0);
        setLimit(PALAdminConstants.DEFAULT_PAGER_LIMIT_SIZE);
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#getLimit()
     */
    public int getLimit()
    {
        return limit;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#setLimit(int)
     */
    public void setLimit(int limit)
    {
        this.limit = limit;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#getCount()
     */
    public int getCount()
    {
        return count;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#setCount(int)
     */
    public void setCount(int count)
    {
        this.count = count;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#getOffset()
     */
    public int getOffset()
    {
        return offset;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.pager.Pager#setOffset(int)
     */
    public void setOffset(int offset)
    {
        this.offset = offset;
    }

}