/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.pager;

import java.io.Serializable;

public class UserPager extends DefaultPager implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 5976446304119300112L;

    private String filter;

    private String authenticationProviderName;

    public UserPager()
    {
        super();
        filter = "";
        authenticationProviderName = null;
    }

    /**
     * @return the filter
     */
    public String getFilter()
    {
        return filter;
    }

    /**
     * @param filter the filter to set
     */
    public void setFilter(String filter)
    {
        this.filter = filter;
    }

    /**
     * @return the authenticationProviderName
     */
    public String getAuthenticationProviderName()
    {
        return authenticationProviderName;
    }

    /**
     * @param authenticationProviderName the authenticationProviderName to set
     */
    public void setAuthenticationProviderName(String authenticationProviderName)
    {
        this.authenticationProviderName = authenticationProviderName;
    }
}
