/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.dxo.PortletApplicationDxo;
import jp.sf.pal.admin.logic.PortletDeploymentLogic;
import jp.sf.pal.admin.logic.PortletManagementLogic;
import jp.sf.pal.admin.pager.PortletApplicationPager;
import jp.sf.pal.admin.util.PagerUtil;
import jp.sf.pal.admin.web.portletmanager.PortletActionConfirmPage;
import jp.sf.pal.admin.web.portletmanager.PortletListPage;

public class PortletManagementService implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 8641303744306860030L;

    private PortletManagementLogic portletManagementLogic;

    private PortletDeploymentLogic portletDeploymentLogic;

    private PortletApplicationPager portletApplicationPager;

    private PortletApplicationDxo portletApplicationDxo;

    /**
     * @return the portletManagementLogic
     */
    public PortletManagementLogic getPortletManagementLogic()
    {
        return portletManagementLogic;
    }

    /**
     * @param portletManagementLogic the portletManagementLogic to set
     */
    public void setPortletManagementLogic(
            PortletManagementLogic portletManagementLogic)
    {
        this.portletManagementLogic = portletManagementLogic;
    }

    /**
     * @return the portletDeploymentLogic
     */
    public PortletDeploymentLogic getPortletDeploymentLogic()
    {
        return portletDeploymentLogic;
    }

    /**
     * @param portletDeploymentLogic the portletDeploymentLogic to set
     */
    public void setPortletDeploymentLogic(
            PortletDeploymentLogic portletDeploymentLogic)
    {
        this.portletDeploymentLogic = portletDeploymentLogic;
    }

    /**
     * @return the portletApplicationPager
     */
    public PortletApplicationPager getPortletApplicationPager()
    {
        return portletApplicationPager;
    }

    /**
     * @param portletApplicationPager the portletApplicationPager to set
     */
    public void setPortletApplicationPager(
            PortletApplicationPager portletApplicationPager)
    {
        this.portletApplicationPager = portletApplicationPager;
    }

    /**
     * @return the portletApplicationDxo
     */
    public PortletApplicationDxo getPortletApplicationDxo()
    {
        return portletApplicationDxo;
    }

    /**
     * @param portletApplicationDxo the portletApplicationDxo to set
     */
    public void setPortletApplicationDxo(
            PortletApplicationDxo portletApplicationDxo)
    {
        this.portletApplicationDxo = portletApplicationDxo;
    }

    public void loadPage(PortletListPage page)
    {
        PortletApplicationPager pager = getPortletApplicationPager();

        // check page action
        PagerUtil.updatePageNumber(pager,
                PALAdminConstants.PREVIOUS_PAGE_NUMBER,
                PALAdminConstants.NEXT_PAGE_NUMBER);

        // set  list
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        portletApplicationDxo.convert(getPortletManagementLogic()
                .getPortletApplications(pager), list);
        PagerUtil.updatePagerPage(page, pager);
        page.setPortletApplicationItems(list);

        // set server manager status
        page.setServerManagerAvailable(getPortletManagementLogic()
                .isServerManagerAvailable());
    }

    public void startPortletApplication(PortletActionConfirmPage page)
            throws PALAdminException
    {
        String portletName = page.getName();
        getPortletDeploymentLogic().startPortletApplication(portletName);
    }

    public void stopPortletApplication(PortletActionConfirmPage page)
            throws PALAdminException
    {
        String portletName = page.getName();
        getPortletDeploymentLogic().stopPortletApplication(portletName);
    }

    public void undeployPortletApplication(PortletActionConfirmPage page)
            throws PALAdminException
    {
        String portletName = page.getName();
        getPortletDeploymentLogic().undeployPortletApplication(portletName);
    }

    public void deletePortletApplication(PortletActionConfirmPage page)
            throws PALAdminException
    {
        String portletName = page.getName();
        getPortletDeploymentLogic().deletePortletApplication(portletName);
    }

}
