/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.dxo.RepositoryDxo;
import jp.sf.pal.admin.logic.RepositoryManagementLogic;
import jp.sf.pal.admin.pager.RepositoryPager;
import jp.sf.pal.admin.rpad.repository.Repository;
import jp.sf.pal.admin.rpad.repository.impl.SimpleRepository;
import jp.sf.pal.admin.util.PagerUtil;
import jp.sf.pal.admin.web.deployer.RemoteRepositoryConfirmPage;
import jp.sf.pal.admin.web.deployer.RemoteRepositoryEditPage;
import jp.sf.pal.admin.web.deployer.RemoteRepositoryListPage;

public class RepositoryManagementService implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = -1590033878393889868L;

    private RepositoryManagementLogic repositoryManagementLogic;

    private RepositoryDxo repositoryDxo;

    private RepositoryPager repositoryPager;

    /**
     * @return the repositoryDxo
     */
    public RepositoryDxo getRepositoryDxo()
    {
        return repositoryDxo;
    }

    /**
     * @param repositoryDxo the repositoryDxo to set
     */
    public void setRepositoryDxo(RepositoryDxo repositoryDxo)
    {
        this.repositoryDxo = repositoryDxo;
    }

    /**
     * @return the repositoryManagementLogic
     */
    public RepositoryManagementLogic getRepositoryManagementLogic()
    {
        return repositoryManagementLogic;
    }

    /**
     * @param repositoryManagementLogic the repositoryManagementLogic to set
     */
    public void setRepositoryManagementLogic(
            RepositoryManagementLogic repositoryManagementLogic)
    {
        this.repositoryManagementLogic = repositoryManagementLogic;
    }

    /**
     * @return the repositoryPager
     */
    public RepositoryPager getRepositoryPager()
    {
        return repositoryPager;
    }

    /**
     * @param repositoryPager the repositoryPager to set
     */
    public void setRepositoryPager(RepositoryPager repositoryPager)
    {
        this.repositoryPager = repositoryPager;
    }

    public void loadPage(RemoteRepositoryListPage page)
    {
        RepositoryPager pager = getRepositoryPager();

        // check page action
        PagerUtil.updatePageNumber(pager,
                PALAdminConstants.PREVIOUS_PAGE_NUMBER,
                PALAdminConstants.NEXT_PAGE_NUMBER);

        // set  list
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        getRepositoryDxo().convert(
                getRepositoryManagementLogic().getRepositories(pager), list);
        PagerUtil.updatePagerPage(page, pager);
        page.setRepositoryItems(list);

    }

    public void create(RemoteRepositoryConfirmPage page)
            throws PALAdminException
    {
        if (page.getName() == null)
        {
            throw new PALAdminException("The repository name is null.");
        }

        getRepositoryManagementLogic().create(page.getName(),
                page.getConfigPath());
        getRepositoryManagementLogic().reload();
    }

    public void update(RemoteRepositoryConfirmPage page)
            throws PALAdminException
    {
        if (page.getName() == null)
        {
            throw new PALAdminException("The repository name is null.");
        }

        getRepositoryManagementLogic().update(page.getName(),
                page.getConfigPath());
        getRepositoryManagementLogic().reload();
    }

    public void delete(RemoteRepositoryConfirmPage page)
            throws PALAdminException
    {
        if (page.getName() == null)
        {
            throw new PALAdminException("The repository name is null.");
        }

        getRepositoryManagementLogic().delete(page.getName());
        getRepositoryManagementLogic().reload();

    }

    public void loadPage(RemoteRepositoryEditPage page)
    {
        Repository repository = getRepositoryManagementLogic().getRepository(
                page.getName());
        if (repository != null)
        {
            if (repository instanceof SimpleRepository)
            {
                SimpleRepository sr = (SimpleRepository) repository;
                page.setConfigPath(sr.getConfigPath());
            }
        }
    }

}
