package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.admin.dxo.SiteEditorDxo;
import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.admin.logic.SiteEditorLogic;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.web.site.AbstractSiteEditorPage;
import jp.sf.pal.admin.web.site.AbstractSiteSecurityEditorPage;
import jp.sf.pal.admin.web.site.FolderAddFolderAndPageEditorPage;
import jp.sf.pal.admin.web.site.FolderInfoEditorPage;
import jp.sf.pal.admin.web.site.FolderSecurityEditorPage;
import jp.sf.pal.admin.web.site.LayoutAddPortletEditorPage;
import jp.sf.pal.admin.web.site.LayoutInfoEditorPage;
import jp.sf.pal.admin.web.site.PageInfoEditorPage;
import jp.sf.pal.admin.web.site.PageSecurityEditorPage;
import jp.sf.pal.admin.web.site.PortletInfoEditorPage;
import jp.sf.pal.common.CommonException;

public class SiteEditorService implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 5510938200628686790L;

    private SiteEditorLogic siteEditorLogic;

    private SiteEditorDxo siteEditorDxo;

    /**
     * @return the siteEditorLogic
     */
    public SiteEditorLogic getSiteEditorLogic() {
        return siteEditorLogic;
    }

    /**
     * @param siteEditorLogic the siteEditorLogic to set
     */
    public void setSiteEditorLogic(SiteEditorLogic siteEditorLogic) {
        this.siteEditorLogic = siteEditorLogic;
    }

    /**
     * @return the siteEditorDxo
     */
    public SiteEditorDxo getSiteEditorDxo() {
        return siteEditorDxo;
    }

    /**
     * @param siteEditorDxo the siteEditorDxo to set
     */
    public void setSiteEditorDxo(SiteEditorDxo siteEditorDxo) {
        this.siteEditorDxo = siteEditorDxo;
    }

    protected void loadSecurityConstraints(AbstractSiteSecurityEditorPage page)
            throws CommonException {
        page.setSecurityConstraintItems(getSiteEditorLogic()
                .getSecurityConstraints(page.getPath()));
    }

    public void loadPage(PageInfoEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setPageDecoratorItems(getSiteEditorLogic()
                .createPageDecorationsList());
        page.setPortletDecoratorItems(getSiteEditorLogic()
                .createPortletDecorationsList());
        page.setDesktopThemeItems(getSiteEditorLogic()
                .createDesktopPageDecorationsList());

        getSiteEditorDxo().convert(
                getSiteEditorLogic().getPageInfo(page.getPath()), page);
    }

    public void loadPage(PageSecurityEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);
        loadSecurityConstraints(page);

        page.setPermissionsItems(getSiteEditorLogic().createPermissionsList());
        page.setSecurityConstraintsRefItems(getSiteEditorLogic()
                .createSecurityConstraintsRefsList());
    }

    public void loadPage(FolderInfoEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setPageDecoratorItems(getSiteEditorLogic()
                .createPageDecorationsList());
        page.setPortletDecoratorItems(getSiteEditorLogic()
                .createPortletDecorationsList());
        page.setDesktopThemeItems(getSiteEditorLogic()
                .createDesktopPageDecorationsList());

        getSiteEditorDxo().convert(
                getSiteEditorLogic().getFolderInfo(page.getPath()), page);
    }

    public void loadPage(FolderAddFolderAndPageEditorPage page)
            throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setLayoutNameItems(getSiteEditorLogic().createLayoutNamesList());
        page.setPageDecoratorItems(getSiteEditorLogic()
                .createPageDecorationsList());
        page.setPortletDecoratorItems(getSiteEditorLogic()
                .createPortletDecorationsList());
        page.setDesktopThemeItems(getSiteEditorLogic()
                .createDesktopPageDecorationsList());

    }

    public void loadPage(FolderSecurityEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);
        loadSecurityConstraints(page);

        page.setPermissionsItems(getSiteEditorLogic().createPermissionsList());
        page.setSecurityConstraintsRefItems(getSiteEditorLogic()
                .createSecurityConstraintsRefsList());
    }

    public void loadPage(LayoutInfoEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setLayoutNameItems(getSiteEditorLogic().createLayoutNamesList());
        page.setDecoratorItems(getSiteEditorLogic()
                .createPortletDecorationsList());
        page.setDesktopThemeItems(getSiteEditorLogic()
                .createDesktopPageDecorationsList());

        getSiteEditorDxo().convert(
                getSiteEditorLogic().getLayoutInfo(page.getPath()), page);
    }

    public void loadPage(LayoutAddPortletEditorPage page)
            throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setLayoutNameItems(getSiteEditorLogic().createLayoutNamesList());
        page.setPortletNameItems(getSiteEditorLogic().createPortletNamesList());

    }

    public void loadPage(PortletInfoEditorPage page) throws CommonException {
        if (!getSiteEditorLogic().checkFolderOrPageViewAccess(page.getPath())) {
            throw new CommonException("could.not.access.path",
                    "Could not access a path: " + page.getPath());
        }

        loadTree(page);

        page.setPortletNameItems(getSiteEditorLogic().createPortletNamesList());
        page.setDecoratorItems(getSiteEditorLogic()
                .createPortletDecorationsList());
        page.setDesktopThemeItems(getSiteEditorLogic()
                .createDesktopPageDecorationsList());

        getSiteEditorDxo().convert(
                getSiteEditorLogic().getPortletInfo(page.getPath()), page);
    }

    protected void loadTree(AbstractSiteEditorPage page) throws CommonException {
        String path = page.getPath();
        if (path != null) {
            String returnPath = page.getReturnPath();
            if (returnPath == null) {
                returnPath = "/";
            }
            page.setNodeItems(getSiteEditorLogic()
                    .getTreeNode(path, returnPath));
        } else {
            List<NodeInfo> empty = new ArrayList<NodeInfo>();
            page.setNodeItems(empty);
        }
    }

    public void updatePage(PageInfoEditorPage page) throws CommonException {
        getSiteEditorLogic().updatePage(page.getPath(), page.getPageTitle(),
                page.getPageShortTitle(), page.getPageDecorator(),
                page.getPortletDecorator(), page.getDesktopTheme(),
                page.isPageHidden());
    }

    public void deletePage(PageInfoEditorPage page) throws CommonException {
        String parent = getSiteEditorLogic().deletePage(page.getPath());
        if (parent != null) {
            page.setPath(parent);
        } else {
            page.setPath("/");
        }
    }

    public void updateFolder(FolderInfoEditorPage page) throws CommonException {
        getSiteEditorLogic().updateFolder(page.getPath(),
                page.getFolderTitle(), page.getFolderShortTitle(),
                page.getPageDecorator(), page.getPortletDecorator(),
                page.getDesktopTheme(), page.isFolderHidden());
    }

    public void deleteFolder(FolderInfoEditorPage page) throws CommonException {
        String parent = getSiteEditorLogic().deleteFolder(page.getPath());
        if (parent != null) {
            page.setPath(parent);
        } else {
            page.setPath("/");
        }
    }

    public void updateLayout(LayoutInfoEditorPage page) throws CommonException {
        getSiteEditorLogic().updateLayout(page.getPath(), page.getLayoutName(),
                page.getDecorator(), page.getDesktopTheme());
    }

    public void deleteLayout(LayoutInfoEditorPage page) throws CommonException {
        String newPath = getSiteEditorLogic().deleteLayout(page.getPath());
        if (newPath != null) {
            page.setPath(newPath);
        } else {
            page.setPath("/");
        }
    }

    public void updatePortlet(PortletInfoEditorPage page)
            throws CommonException {
        getSiteEditorLogic().updatePortlet(page.getPath(),
                page.getPortletName(), page.getDecorator(),
                page.getDesktopTheme());
    }

    public void deletePortlet(PortletInfoEditorPage page)
            throws CommonException {
        String newPath = getSiteEditorLogic().deletePortlet(page.getPath());
        if (newPath != null) {
            page.setPath(newPath);
        } else {
            page.setPath("/");
        }
    }

    public void addLayout(LayoutAddPortletEditorPage page)
            throws CommonException {
        if (page.getLayoutName() == null) {
            throw new CommonException("need.to.specify.layout",
                    "a layout is empty");
        }
        getSiteEditorLogic().addLayout(page.getPath(), page.getLayoutName());
    }

    public void addPortlet(LayoutAddPortletEditorPage page)
            throws CommonException {
        if (page.getPortletName() == null) {
            throw new CommonException("need.to.specify.portlet",
                    "a portlet is empty");
        }
        getSiteEditorLogic().addPortlet(page.getPath(), page.getPortletName());
    }

    public void addFolder(FolderAddFolderAndPageEditorPage page)
            throws CommonException {
        String name = page.getFolderOrPageName();
        if (name == null) {
            throw new CommonException("need.to.specify.folder.name",
                    "a folder name is empty");
        }
        if (name.endsWith(".psml")) {
            // cut .psml
            name = name.substring(0, name.length() - 4);
        }
        if ("".equals(name)) {
            throw new CommonException("need.to.specify.folder.name",
                    "a folder name is empty");
        }
        getSiteEditorLogic().addFolder(page.getPath(), name,
                page.getFolderOrPageTitle(), page.getFolderOrPageShortTitle(),
                page.getLayoutName(), page.getPageDecorator(),
                page.getPortletDecorator(), page.getDesktopTheme(),
                page.isFolderOrPageHidden());
    }

    public void addPage(FolderAddFolderAndPageEditorPage page)
            throws CommonException {
        String name = page.getFolderOrPageName();
        if (name == null) {
            throw new CommonException("need.to.specify.page.name",
                    "a page name is empty");
        }
        if (!name.endsWith(".psml")) {
            // add .psml
            name = name + ".psml";
        }
        if ("".equals(name)) {
            throw new CommonException("need.to.specify.page.name",
                    "a page name is empty");
        }
        getSiteEditorLogic().addPage(page.getPath(), name,
                page.getFolderOrPageTitle(), page.getFolderOrPageShortTitle(),
                page.getLayoutName(), page.getPageDecorator(),
                page.getPortletDecorator(), page.getDesktopTheme(),
                page.isFolderOrPageHidden());
    }

    public void addConstraint(PageSecurityEditorPage page)
            throws CommonException {
        List<String> users = PALAdminUtil.parseCSVList(page.getUsers());
        List<String> roles = PALAdminUtil.parseCSVList(page.getRoles());
        List<String> groups = PALAdminUtil.parseCSVList(page.getGroups());
        if (users.isEmpty() && roles.isEmpty() && groups.isEmpty()) {
            throw new CommonException("need.to.specify.users.roles.groups",
                    "users, roles and groups are empty");
        }

        if (page.getPermissions() == null || page.getPermissions().length == 0) {
            throw new CommonException("need.to.specify.permissions",
                    "permissions are empty");
        }
        String[] p = page.getPermissions();
        List<String> permissions = new ArrayList<String>();
        for (int i = 0; i < p.length; i++) {
            permissions.add(p[i]);
        }

        getSiteEditorLogic().addConstraint(page.getPath(), users, roles,
                groups, permissions);
    }

    public void addConstraintRef(PageSecurityEditorPage page)
            throws CommonException {
        if (page.getSecurityConstraintsRef() == null) {
            throw new CommonException(
                    "need.to.specify.security.constraint.ref",
                    "Security ConstraintRef is empty");
        }

        getSiteEditorLogic().addConstraintRef(page.getPath(),
                page.getSecurityConstraintsRef());
    }

    public void removeConstraint(PageSecurityEditorPage page)
            throws CommonException {
        getSiteEditorLogic().removeConstraint(page.getPath(),
                page.getApplyOrder().intValue());
    }

    public void removeConstraintRef(PageSecurityEditorPage page)
            throws CommonException {
        getSiteEditorLogic().removeConstraintRef(page.getPath(),
                page.getApplyOrder().intValue());
    }

    public void addConstraint(FolderSecurityEditorPage page)
            throws CommonException {
        List<String> users = PALAdminUtil.parseCSVList(page.getUsers());
        List<String> roles = PALAdminUtil.parseCSVList(page.getRoles());
        List<String> groups = PALAdminUtil.parseCSVList(page.getGroups());
        if (users.isEmpty() && roles.isEmpty() && groups.isEmpty()) {
            throw new CommonException("need.to.specify.users.roles.groups",
                    "users, roles and groups are empty");
        }

        if (page.getPermissions() == null || page.getPermissions().length == 0) {
            throw new CommonException("need.to.specify.permissions",
                    "permissions are empty");
        }
        String[] p = page.getPermissions();
        List<String> permissions = new ArrayList<String>();
        for (int i = 0; i < p.length; i++) {
            permissions.add(p[i]);
        }

        getSiteEditorLogic().addConstraint(page.getPath(), users, roles,
                groups, permissions);
    }

    public void addConstraintRef(FolderSecurityEditorPage page)
            throws CommonException {
        if (page.getSecurityConstraintsRef() == null) {
            throw new CommonException(
                    "need.to.specify.security.constraint.ref",
                    "Security ConstraintRef is empty");
        }

        getSiteEditorLogic().addConstraintRef(page.getPath(),
                page.getSecurityConstraintsRef());
    }

    public void removeConstraint(FolderSecurityEditorPage page)
            throws CommonException {
        getSiteEditorLogic().removeConstraint(page.getPath(),
                page.getApplyOrder().intValue());
    }

    public void removeConstraintRef(FolderSecurityEditorPage page)
            throws CommonException {
        getSiteEditorLogic().removeConstraintRef(page.getPath(),
                page.getApplyOrder().intValue());
    }

    public String getReturnPathURL(String returnPath) {
        //"${req.scheme}://${req.serverName}:${req.serverPort}${req.contextPath}/
        HttpServletRequest request = getSiteEditorLogic().getRequestContext()
                .getRequest();
        StringBuffer buf = new StringBuffer();
        buf.append(request.getScheme()).append("://").append(
                request.getServerName()).append(":").append(
                request.getServerPort()).append(request.getContextPath());

        if (!buf.toString().endsWith("/")) {
            buf.append("/");
        }
        // TODO portal or configuration
        buf.append("portal/");

        if (returnPath != null && returnPath.startsWith("/")) {
            buf.append(returnPath.substring(1));
        } else {
            buf.append(returnPath);
        }

        return buf.toString();
    }

    public int getNodeInfoType(String path) {
        return getSiteEditorLogic().getNodeInfoType(path);
    }

    public Boolean isEditable(String path) {
        try {
            return new Boolean(getSiteEditorLogic()
                    .checkFolderOrPageEditAccess(path));
        } catch (CommonException e) {
            return Boolean.FALSE;
        }
    }
}
