/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.security.auth.Subject;

import org.apache.jetspeed.om.common.SecuredResource;

import jp.sf.pal.admin.PALAdminConstants;

public class PALAdminUtil {
    /**
     * @return the facesContext
     */
    private static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static boolean isEmpty(String s) {
        if (s == null)
            return true;

        if (s.trim().equals(""))
            return true;

        return false;
    }

    public static Principal getPrincipal(Subject subject, Class cls) {
        Principal principal = null;
        Iterator principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = (Principal) principals.next();
            if (cls.isInstance(p)) {
                principal = p;
                break;
            }
        }
        return principal;
    }

    public static Map<String, String> createItem(String label, String value) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("label", label);
        map.put("value", value);
        return map;
    }

    public static List<Map<String, String>> createItems(Iterator<String> items) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        while (items.hasNext()) {
            String value = items.next();
            list.add(PALAdminUtil.createItem(value, value));
        }
        return list;
    }

    public static String toStringFromList(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (Iterator<String> ite = list.iterator(); ite.hasNext();) {
            buf.append(ite.next());
            if (ite.hasNext()) {
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static String toStringFromArray(Object[] strs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strs.length; i++) {
            buf.append(strs[i].toString());
            if (i + 1 < strs.length) {
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static void drain(InputStream in, OutputStream out)
            throws IOException {
        try {
            byte[] buf = new byte[8192];
            int len = in.read(buf);

            while (len != -1) {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
            out.flush();
        } catch (IOException e) {
            throw e;
        } finally {
            try {
                out.close();
            } catch (IOException e) {
            }
            try {
                in.close();
            } catch (IOException e) {
            }
        }
    }

    public static void setPasswordToSession(String value) {
        getFacesContext().getExternalContext().getSessionMap().put(
                PALAdminConstants.PASSWORD, value);
    }

    public static String getPasswordFromSession() {
        return (String) getFacesContext().getExternalContext().getSessionMap()
                .get(PALAdminConstants.PASSWORD);
    }

    public static void removePasswordFromSession() {
        getFacesContext().getExternalContext().getSessionMap().remove(
                PALAdminConstants.PASSWORD);
    }

    public static String getContextRealPath(String path) {
        return getPortletConfig().getPortletContext().getRealPath(path);
    }

    public static PortletConfig getPortletConfig() {
        String name = "javax.portlet.PortletConfig";
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new IllegalStateException(
                    "Could not find FacesContext instance.");
        }
        return (PortletConfig) context.getExternalContext().getRequestMap()
                .get(name);
    }

    public static String formatCSVList(List<String> list) {
        if ((list != null) && !list.isEmpty()) {
            StringBuffer csv = new StringBuffer();
            Iterator<String> listIter = list.iterator();
            while (listIter.hasNext()) {
                if (csv.length() > 0) {
                    csv.append(",");
                }
                csv.append((String) listIter.next());
            }
            return csv.toString();
        }
        return "";
    }

    public static List<String> parseCSVList(String csv) {
        List<String> csvList = new ArrayList<String>();
        if (csv != null) {
            if (csv.indexOf(',') != -1) {
                StringTokenizer csvTokens = new StringTokenizer(csv, ",");
                while (csvTokens.hasMoreTokens()) {
                    csvList.add(csvTokens.nextToken().trim());
                }
            } else {
                csvList.add(csv);
            }
        }
        return csvList;
    }

    public static boolean checkAccess(SecuredResource securedResource,
            String actions) {
        try {
            securedResource.checkAccess(actions);
            return true;
        } catch (SecurityException e) {
            return false;
        }
    }
}
