package jp.sf.pal.admin.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;

import org.apache.jetspeed.locator.JetspeedTemplateLocator;

import jp.sf.pal.admin.PALAdminConstants;

public class UserRegistrationUtil
{
    private static FacesContext getFacesContext()
    {
        return FacesContext.getCurrentInstance();
    }

    public static Map<String, Object> getUserRegistrationParams()
    {
        Map<String, Object> params = (Map<String, Object>) getFacesContext()
                .getExternalContext().getRequestMap().get(
                        PALAdminConstants.USER_REGISTRATION_PARAMS);
        if (params == null)
        {
            throw new IllegalStateException(
                    "The user registration params is null. ");
        }
        return params;
    }

    public static boolean getBoolean(String key)
    {
        Object value = getUserRegistrationParams().get(key);
        if (value == null)
        {
            return false;
        }
        return ((Boolean) value).booleanValue();
    }

    public static String getString(String key)
    {
        return (String) getUserRegistrationParams().get(key);
    }

    public static List<String> getStringList(String key)
    {
        Object value = getUserRegistrationParams().get(key);
        if (value == null)
        {
            return new ArrayList<String>();
        }
        return (List<String>) value;

    }

    public static Map<String, String> getStringMap(String key)
    {
        Object value = getUserRegistrationParams().get(key);
        if (value == null)
        {
            return new HashMap<String, String>();
        }
        return (Map<String, String>) value;

    }

    public static JetspeedTemplateLocator getTemplateLocator()
    {
        return (JetspeedTemplateLocator) getUserRegistrationParams().get(
                PALAdminConstants.TEMPLATE_LOCATOR);
    }

    public static String makeGUID(String user, String newpw)
    {
        // This is a quicky version
        long num = (long) user.hashCode() + (long) newpw.hashCode(); //  Possible collisions here...
        long d = new Date().getTime();
        long val = num * d;
        String retval = Long.toHexString(val);
        return retval;
    }

}
