/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.util.UserRegistrationUtil;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;

public class PublicPortalRegistrationRegisterPage extends
        AbstractPublicPortalRegistrationPage {
    /**
     * 
     */
    private static final long serialVersionUID = 5818687558352917312L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(PublicPortalRegistrationRegisterPage.class);

    public static final String userName_TRequiredValidator = null;

    public static final String userName_lengthValidator = "minimum=6, maximum=32";

    public static final String userNameFamily_TRequiredValidator = null;

    public static final String userNameFamily_lengthValidator = " maximum=30";

    public static final String userNameGiven_TRequiredValidator = null;

    public static final String userNameGiven_lengthValidator = "maximum=30";

    public static final String userNameFamilyYomi_TRequiredValidator = null;

    public static final String userNameFamilyYomi_lengthValidator = " maximum=30";

    public static final String userNameGivenYomi_TRequiredValidator = null;

    public static final String userNameGivenYomi_lengthValidator = "maximum=30";

    public static final String userHomeInfoPostalPostalcode_TRequiredValidator = null;

    public static final String userHomeInfoPostalPostalcode_lengthValidator = "maximum=8";

    public static final String userGender_TRequiredValidator = null;

    public static final String userBdateYear_TRequiredValidator = null;

    public static final String userBdateYear_TNumberLengthValidator = "integralMax=4";

    public static final String userBdateMonth_TRequiredValidator = null;

    public static final String userBdateMonth_TNumberLengthValidator = "integralMax=2";

    public static final String userBdateDate_TRequiredValidator = null;

    public static final String userBdateDate_TNumberLengthValidator = "integralMax=2";

    public static final String userBusinessInfoOnlineEmail_TRequiredValidator = null;

    public static final String userBusinessInfoOnlineEmail_lengthValidator = "minimum=5, maximum=80";

    public static final String userIndustry_TRequiredValidator = null;

    public static final String userJobtitle_TRequiredValidator = null;

    //    public static final String userSecretQuestion_TRequiredValidator = null;

    public static final String userSecretQuestion_lengthValidator = "maximum=100";

    public static final String userSecretAnswer_TRequiredValidator = null;

    public static final String userSecretAnswer_lengthValidator = "maximum=100";

    private String userSecretQuestionSelection;

    private List<Map<String, String>> userSecretQuestionSelectionItems;

    private int userSecretQuestionSelectionIndex;

    /**
     * @return the userSecretQuestionSelection
     */
    public String getUserSecretQuestionSelection() {
        return userSecretQuestionSelection;
    }

    /**
     * @param userSecretQuestionSelection the userSecretQuestionSelection to set
     */
    public void setUserSecretQuestionSelection(
            String userSecretQuestionSelection) {
        this.userSecretQuestionSelection = userSecretQuestionSelection;
    }

    /**
     * @return the userSecretQuestionSelectionItems
     */
    public List<Map<String, String>> getUserSecretQuestionSelectionItems() {
        return userSecretQuestionSelectionItems;
    }

    /**
     * @param userSecretQuestionSelectionItems the userSecretQuestionSelectionItems to set
     */
    public void setUserSecretQuestionSelectionItems(
            List<Map<String, String>> userSecretQuestionSelectionItems) {
        this.userSecretQuestionSelectionItems = userSecretQuestionSelectionItems;
    }

    /**
     * @return the userSecretQuestionSelectionIndex
     */
    public int getUserSecretQuestionSelectionIndex() {
        return userSecretQuestionSelectionIndex;
    }

    /**
     * @param userSecretQuestionSelectionIndex the userSecretQuestionSelectionIndex to set
     */
    public void setUserSecretQuestionSelectionIndex(
            int userSecretQuestionSelectionIndex) {
        this.userSecretQuestionSelectionIndex = userSecretQuestionSelectionIndex;
    }

    public Class<?> doFinish() {
        if (getUserBusinessInfoOnlineEmail() != null) {
            setUserHomeInfoOnlineEmail(getUserBusinessInfoOnlineEmail());
        }

        if (userSecretQuestionSelection != null) {
            setUserSecretQuestion(userSecretQuestionSelection);
        }

        try {
            setUserSecretAnswer(getUserRegistrationService().getMessageDigest(
                    getUserSecretAnswer()));
            getUserRegistrationService().register(this);
            if (UserRegistrationUtil.getBoolean(PALAdminConstants.SEND_MAIL)) {
                FacesMessageUtil.addInfoMessage("success.check_your_email");
                return PublicPortalRegistrationCompletedPage.class;
            } else {
                FacesMessageUtil.addInfoMessage("success.login_above");
            }
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);

        }

        return null;
    }

    public Class<?> initialize() {
        // Load Term Of Service
        String filename = getLabelHelper().getLabelValue("termOfServiceFile");
        if (filename == null) {
            filename = "/WEB-INF/template/term_of_service.txt";
        }
        String encoding = getLabelHelper().getLabelValue(
                "termOfServiceEncoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(PALAdminUtil
                            .getContextRealPath(filename)), encoding));
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append("\n");
            }
        } catch (UnsupportedEncodingException e) {
            FacesMessageUtil.addErrorMessage("could.not.read.term.of.service");
            logger.log("EPA0004", new Object[] { this.toString() }, e);
        } catch (FileNotFoundException e) {
            FacesMessageUtil.addErrorMessage("could.not.read.term.of.service");
            logger.log("EPA0004", new Object[] { this.toString() }, e);
        } catch (IOException e) {
            FacesMessageUtil.addErrorMessage("could.not.read.term.of.service");
            logger.log("EPA0004", new Object[] { this.toString() }, e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                }
            }
        }
        setTermOfService(buf.toString());

        return null;
    }

    public Class<?> prerender() {
        // Load Secret Question
        List<Map<String, String>> questionItems = new ArrayList<Map<String, String>>();
        int numOfQuestions = Integer.parseInt(getLabelHelper().getLabelValue(
                "secretQuestion.num"));
        for (int i = 1; i <= numOfQuestions; i++) {
            Map<String, String> map = new HashMap<String, String>(2);
            String value = getLabelHelper()
                    .getLabelValue("secretQuestion." + i);
            map.put("label", value);
            map.put("value", value);
            questionItems.add(map);
        }
        setUserSecretQuestionSelectionItems(questionItems);

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

}
