/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;

public class PublicPortalRegistrationUpdatePage extends
        AbstractPublicPortalRegistrationPage implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -2415175365437526156L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(PublicPortalRegistrationUpdatePage.class);

    public static final String userName_TRequiredValidator = null;

    public static final String userName_lengthValidator = "minimum=6, maximum=32";

    public static final String userNameFamily_TRequiredValidator = null;

    public static final String userNameFamily_lengthValidator = " maximum=30";

    public static final String userNameGiven_TRequiredValidator = null;

    public static final String userNameGiven_lengthValidator = "maximum=30";

    public static final String userNameFamilyYomi_TRequiredValidator = null;

    public static final String userNameFamilyYomi_lengthValidator = " maximum=30";

    public static final String userNameGivenYomi_TRequiredValidator = null;

    public static final String userNameGivenYomi_lengthValidator = "maximum=30";

    public static final String userHomeInfoPostalPostalcode_TRequiredValidator = null;

    public static final String userHomeInfoPostalPostalcode_lengthValidator = "maximum=8";

    public static final String userGender_TRequiredValidator = null;

    public static final String userBdateYear_TRequiredValidator = null;

    public static final String userBdateYear_TNumberLengthValidator = "integralMax=4";

    public static final String userBdateMonth_TRequiredValidator = null;

    public static final String userBdateMonth_TNumberLengthValidator = "integralMax=2";

    public static final String userBdateDate_TRequiredValidator = null;

    public static final String userBdateDate_TNumberLengthValidator = "integralMax=2";

    public static final String userBusinessInfoOnlineEmail_TRequiredValidator = null;

    public static final String userBusinessInfoOnlineEmail_lengthValidator = "minimum=5, maximum=80";

    public static final String userIndustry_TRequiredValidator = null;

    public static final String userJobtitle_TRequiredValidator = null;

    public static final String userSecretQuestion_TRequiredValidator = null;

    public static final String userSecretQuestion_lengthValidator = "maximum=100";

    public static final String userSecretAnswer_TRequiredValidator = null;

    public static final String userSecretAnswer_lengthValidator = "maximum=100";

    public Class<?> doFinish() {
        try {
            if (!PALAdminConstants.SECRET_ANSWER_DISPLAY
                    .equals(getUserSecretAnswer())) {
                setUserSecretAnswer(getUserRegistrationService()
                        .getMessageDigest(getUserSecretAnswer()));
            }
            getUserRegistrationService().update(this);
            FacesMessageUtil.addInfoMessage("updated.user.info");
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }
        return null;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        try {
            getUserRegistrationService().loadPage(this);
            setUserSecretAnswer(PALAdminConstants.SECRET_ANSWER_DISPLAY);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

}
