/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class PublicPortalSecretAnswerPage extends AbstractForgottenPasswordPage
        implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -3654426468628202950L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(PublicPortalSecretAnswerPage.class);

    private String userSecretAnswer;

    private String userSecretQuestion;

    public String getUserSecretAnswer() {
        return userSecretAnswer;
    }

    public void setUserSecretAnswer(String userSecretAnswer) {
        this.userSecretAnswer = userSecretAnswer;
    }

    public String getUserSecretQuestion() {
        return userSecretQuestion;
    }

    public void setUserSecretQuestion(String userSecretQuestion) {
        this.userSecretQuestion = userSecretQuestion;
    }

    public Class<?> doFinish() {
        try {
            if (!PALAdminConstants.SECRET_ANSWER_DISPLAY
                    .equals(getUserSecretAnswer())) {
                setUserSecretAnswer(getUserRegistrationService()
                        .getMessageDigest(getUserSecretAnswer()));
            }
            if (getUserRegistrationService().checkSecretAnswer(this)) {
                try {
                    getUserRegistrationService().sendNewPassword(this);
                    FacesMessageUtil.addInfoMessage("an_email_has_been_sent");
                    return PublicPortalForgottenPasswordCompletedPage.class;
                } catch (CommonException e) {
                    FacesMessageUtil.addErrorMessage(e.getMessageId());
                    logger.log("EPA0002", new Object[] { this.toString() }, e);
                    setUserSecretAnswer(null);
                }

            } else {
                FacesMessageUtil.addInfoMessage("incorrect.scret.answer");
                setUserSecretAnswer(null);
            }
        } catch (CommonException e) {
            //            FacesMessageUtil.addErrorMessage(e.getMessageId());
            FacesMessageUtil.addInfoMessage("incorrect.scret.answer");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
            setUserSecretAnswer(null);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.NEVER)
    public Class<?> doBack() {
        return PublicPortalForgottenPasswordPage.class;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        setGuid((String) FacesContext.getCurrentInstance().getExternalContext()
                .getRequestParameterMap().get("guid"));
        if (getGuid() != null) {
            return PublicPortalForgottenPasswordCompletedPage.class;
        }

        if (getEmail() == null) {
            return PublicPortalForgottenPasswordPage.class;
        }

        try {
            getUserRegistrationService().setSecretQuestion(this);
        } catch (CommonException e) {
            logger.log("EPA0005", new Object[] { this.toString() }, e);
            //            return PublicPortalForgottenPasswordPage.class;
        }

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

    public String getDoFinishValue() {
        return getLabelHelper().getLabelValue("Finish");
    }

    public String getDoBackValue() {
        return getLabelHelper().getLabelValue("Back");
    }

}
