package jp.sf.pal.admin.web.registration;

import java.io.IOException;
import java.io.Serializable;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;

public class ResetPasswordPage extends AbstractResetPasswordPage implements
        Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -774792006598626453L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(ResetPasswordPage.class);

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        if (getGuid() != null) {
            try {
                getUserRegistrationService().updatePassword(this);
                FacesMessageUtil
                        .addInfoMessage("forgotten.successful_pw_update");
            } catch (CommonException e) {
                FacesMessageUtil.addErrorMessage(e.getMessageId());
                logger.log("EPA0003", new Object[] { this.toString() }, e);
            }
        }

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

    public Class<?> doLogin() {
        ExternalContext externalContext = FacesContext.getCurrentInstance()
                .getExternalContext();
        try {
            externalContext
                    .redirect(externalContext.getRequestContextPath()
                            + "/login/proxy?org.apache.jetspeed.login.username=&org.apache.jetspeed.login.password=");
        } catch (IOException e) {
            return ForgottenPasswordPage.class;
        }
        return null;
    }

    public String getDoLoginValue() {
        return getLabelHelper().getLabelValue("login");
    }

    public String getGoForgottenPasswordValue() {
        return getLabelHelper().getLabelValue("sendNewPassword");
    }
}
