package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import org.seasar.framework.log.Logger;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.util.UserRegistrationUtil;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

public class UserRegistrationPage extends AbstractUserRegistrationPage
        implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -5852964123222268945L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserRegistrationPage.class);

    // TODO validation

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

    public Class<?> doFinish() {
        try {
            getUserRegistrationService().register(this);
            if (UserRegistrationUtil.getBoolean(PALAdminConstants.SEND_MAIL)) {
                FacesMessageUtil.addInfoMessage("success.check_your_email");
            } else {
                FacesMessageUtil.addInfoMessage("success.login_above");
            }
            return UserRegistrationPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);

        }

        return null;
    }

    public String getDoFinishValue() {
        return getLabelHelper().getLabelValue("SignUp");
    }

}
