/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.role;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.service.RoleManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;
import jp.sf.pal.admin.web.CrudType;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.teeda.extension.annotation.takeover.TakeOver;

public class RoleListPage extends AbstractPagerPage implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -9134524940073547390L;

    private int roleIndex;

    private List<Map<String, Object>> roleItems;

    private String name;

    private RoleManagementService roleManagementService;

    public RoleListPage() {
        super();

    }

    public String getName() {
        return name;
    }

    public void setName(String roleName) {
        this.name = roleName;
    }

    /**
     * @return the roleIndex
     */
    public int getRoleIndex() {
        return roleIndex;
    }

    /**
     * @param roleIndex the roleIndex to set
     */
    public void setRoleIndex(int roleIndex) {
        this.roleIndex = roleIndex;
    }

    /**
     * @return the roleItems
     */
    public List<Map<String, Object>> getRoleItems() {
        return roleItems;
    }

    /**
     * @param roleItems the roleItems to set
     */
    public void setRoleItems(List<Map<String, Object>> roleItems) {
        this.roleItems = roleItems;
    }

    /**
     * @return the roleManagementService
     */
    public RoleManagementService getRoleManagementService() {
        return roleManagementService;
    }

    /**
     * @param roleManagementService the roleManagementService to set
     */
    public void setRoleManagementService(
            RoleManagementService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public String initialize() {
        return null;
    }

    public String prerender() {
        roleManagementService.loadPage(this);

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(properties = "crudType")
    public Class doCreate() {
        setCrudType(CrudType.CREATE);
        return RoleEditPage.class;
    }

}
