/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.admin.service.SiteEditorService;

import org.seasar.teeda.extension.util.LabelHelper;

public abstract class AbstractSiteEditorPage {
    private List<NodeInfo> nodeItems;

    private int nodeIndex;

    private String path;

    private String returnPath;

    private String name;

    private SiteEditorService siteEditorService;

    private LabelHelper labelHelper;

    private Boolean editable;

    /**
     * @return the labelHelper
     */
    public LabelHelper getLabelHelper() {
        return labelHelper;
    }

    /**
     * @param labelHelper the labelHelper to set
     */
    public void setLabelHelper(LabelHelper labelHelper) {
        this.labelHelper = labelHelper;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the nodeItems
     */
    public List<NodeInfo> getNodeItems() {
        return nodeItems;
    }

    /**
     * @param nodeItems the nodeItems to set
     */
    public void setNodeItems(List<NodeInfo> nodeItems) {
        this.nodeItems = nodeItems;
    }

    /**
     * @return the nodeIndex
     */
    public int getNodeIndex() {
        return nodeIndex;
    }

    /**
     * @param nodeIndex the nodeIndex to set
     */
    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public AbstractSiteEditorPage() {
        super();
    }

    /**
     * @return the path
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path the path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return the returnPath
     */
    public String getReturnPath() {
        return returnPath;
    }

    /**
     * @param returnPath the returnPath to set
     */
    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    /**
     * @return the siteEditorSerivce
     */
    public SiteEditorService getSiteEditorService() {
        return siteEditorService;
    }

    /**
     * @param siteEditorSerivce the siteEditorSerivce to set
     */
    public void setSiteEditorService(SiteEditorService siteEditorService) {
        this.siteEditorService = siteEditorService;
    }

    public String getJumpFolderInfoEditorStyle() {
        return getJumpEditorStyle();
    }

    public String getJumpPageInfoEditorStyle() {
        return getJumpEditorStyle();
    }

    public String getJumpLayoutInfoEditorStyle() {
        return getJumpEditorStyle();
    }

    public String getJumpPortletInfoEditorStyle() {
        return getJumpEditorStyle();
    }

    protected String getJumpEditorStyle() {
        StringBuffer buf = new StringBuffer(
                "text-decoration: none;margin-left:");
        NodeInfo entity = getNodeItems().get(getNodeIndex());
        buf.append(entity.getDepth() * 10);
        buf.append("px;");
        if (entity.isSelected()) {
            buf.append("background-color:yellow;");
        }
        return buf.toString();
    }

    public String getFolderIconSrc() {
        return getIconSrc();
    }

    public String getPageIconSrc() {
        return getIconSrc();
    }

    public String getLayoutIconSrc() {
        return getIconSrc();
    }

    public String getPortletIconSrc() {
        return getIconSrc();
    }

    public String getIconSrc() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringBuffer buf = new StringBuffer(facesContext.getExternalContext()
                .getRequestContextPath()
                + "/images/");

        NodeInfo entity = getNodeItems().get(getNodeIndex());
        if (entity.getType() == NodeInfo.FOLDER) {
            buf.append("folder");
        } else if (entity.getType() == NodeInfo.PAGE) {
            buf.append("page");
        } else if (entity.getType() == NodeInfo.LAYOUT) {
            buf.append("layout");
        } else if (entity.getType() == NodeInfo.PORTLET) {
            buf.append("portlet");
        } else {
            buf.append("none");
        }
        buf.append(".png");
        return buf.toString();
    }

    public boolean isFolder() {
        NodeInfo entity = getNodeItems().get(getNodeIndex());
        return entity.getType() == NodeInfo.FOLDER;
    }

    public boolean isPage() {
        NodeInfo entity = getNodeItems().get(getNodeIndex());
        return entity.getType() == NodeInfo.PAGE;
    }

    public boolean isPageLayout() {
        // cannot use isLayout
        NodeInfo entity = getNodeItems().get(getNodeIndex());
        return entity.getType() == NodeInfo.LAYOUT;
    }

    public boolean isPortlet() {
        NodeInfo entity = getNodeItems().get(getNodeIndex());
        return entity.getType() == NodeInfo.PORTLET;
    }

    public String getReturnPathLinkHref() {
        return getSiteEditorService().getReturnPathURL(getReturnPath());
    }

    public String getCurrentPath() {
        return path;
    }

    public void parseRequestParameters() {
        Map<?, ?> requestParameterMap = FacesContext.getCurrentInstance()
                .getExternalContext().getRequestParameterMap();

        // path
        String path = (String) requestParameterMap.get("path");
        if (path != null) {
            setPath(path);
        }

        // returnPath
        String returnPath = (String) requestParameterMap.get("returnPath");
        if (returnPath != null) {
            setReturnPath(returnPath);
        }
    }

    public boolean isEditable() {
        if (editable == null) {
            editable = getSiteEditorService().isEditable(getPath());
        }
        return editable.booleanValue();
    }
}