/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;

public abstract class AbstractSiteSecurityEditorPage extends
        AbstractSiteEditorPage {

    private String securityConstraintName;

    private String groups;

    private String roles;

    private int securityConstraintIndex;

    private List<Map<String, Object>> securityConstraintItems;

    private String securityConstraintsRef;

    private List<Map<String, String>> securityConstraintsRefItems;

    private String users;

    private Integer applyOrder;

    private String securityConstraintType;

    private String action;

    private String[] permissions;

    private List<Map<String, String>> permissionsItems;

    /**
     * @return the action
     */
    public String getAction() {
        return action;
    }

    /**
     * @param action the action to set
     */
    public void setAction(String action) {
        this.action = action;
    }

    /**
     * @return the permissions
     */
    public String[] getPermissions() {
        return permissions;
    }

    /**
     * @param permissions the permissions to set
     */
    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    /**
     * @return the permissionsItems
     */
    public List<Map<String, String>> getPermissionsItems() {
        return permissionsItems;
    }

    /**
     * @param permissionsItems the permissionsItems to set
     */
    public void setPermissionsItems(List<Map<String, String>> permissionsItems) {
        this.permissionsItems = permissionsItems;
    }

    public String getSecurityConstraintName() {
        return securityConstraintName;
    }

    public void setSecurityConstraintName(String constraintName) {
        this.securityConstraintName = constraintName;
    }

    public String getSecurityConstraintTypeName() {
        if (securityConstraintItems == null
                || securityConstraintItems.isEmpty()
                || securityConstraintIndex >= securityConstraintItems.size()) {
            return null;
        }
        Map<String, Object> map = securityConstraintItems
                .get(securityConstraintIndex);
        return getLabelHelper().getLabelValue(
                (String) map.get(PALAdminConstants.SECURITY_CONSTRAINT_TYPE)
                        + "Type");
    }

    public String getSecurityConstraintPermissionName() {
        if (securityConstraintItems == null
                || securityConstraintItems.isEmpty()
                || securityConstraintIndex >= securityConstraintItems.size()) {
            return null;
        }
        Map<String, Object> map = securityConstraintItems
                .get(securityConstraintIndex);
        String permission = (String) map
                .get(PALAdminConstants.SECURITY_CONSTRAINT_PERMISSION);
        if (permission != null) {
            return permission;
        }
        return "-";
    }

    public String getGroups() {
        return groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getRoles() {
        return roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public int getSecurityConstraintIndex() {
        return securityConstraintIndex;
    }

    public void setSecurityConstraintIndex(int securityConstraintIndex) {
        this.securityConstraintIndex = securityConstraintIndex;
    }

    public List<Map<String, Object>> getSecurityConstraintItems() {
        return securityConstraintItems;
    }

    public void setSecurityConstraintItems(
            List<Map<String, Object>> securityConstraintItems) {
        this.securityConstraintItems = securityConstraintItems;
    }

    public String getSecurityConstraintsRef() {
        return securityConstraintsRef;
    }

    public void setSecurityConstraintsRef(String securityConstraintsRef) {
        this.securityConstraintsRef = securityConstraintsRef;
    }

    public List<Map<String, String>> getSecurityConstraintsRefItems() {
        return securityConstraintsRefItems;
    }

    public void setSecurityConstraintsRefItems(
            List<Map<String, String>> securityConstraintsRefItems) {
        this.securityConstraintsRefItems = securityConstraintsRefItems;
    }

    public String getUsers() {
        return users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    /**
     * @return the applyOrder
     */
    public Integer getApplyOrder() {
        return applyOrder;
    }

    /**
     * @param applyOrder the applyOrder to set
     */
    public void setApplyOrder(Integer applyOrder) {
        this.applyOrder = applyOrder;
    }

    /**
     * @return the securityConstraintType
     */
    public String getSecurityConstraintType() {
        return securityConstraintType;
    }

    /**
     * @param securityConstraintType the securityConstraintType to set
     */
    public void setSecurityConstraintType(String securityConstraintType) {
        this.securityConstraintType = securityConstraintType;
    }

}
