/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;
import org.seasar.teeda.extension.annotation.validator.Required;

public class FolderAddFolderAndPageEditorPage extends AbstractSiteEditorPage
        implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 7554996409131145939L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(FolderInfoEditorPage.class);

    @Required
    private String layoutName;

    private List<Map<String, String>> layoutNameItems;

    private String desktopTheme;

    private List<Map<String, String>> desktopThemeItems;

    private boolean folderOrPageHidden;

    private String folderOrPageName;

    private String folderOrPageShortTitle;

    private String folderOrPageTitle;

    @Required
    private String pageDecorator;

    private List<Map<String, String>> pageDecoratorItems;

    @Required
    private String portletDecorator;

    private List<Map<String, String>> portletDecoratorItems;

    /**
     * @return the layoutName
     */
    public String getLayoutName() {
        return layoutName;
    }

    /**
     * @param layoutName the layoutName to set
     */
    public void setLayoutName(String layoutName) {
        this.layoutName = layoutName;
    }

    /**
     * @return the layoutNameItems
     */
    public List<Map<String, String>> getLayoutNameItems() {
        return layoutNameItems;
    }

    /**
     * @param layoutNameItems the layoutNameItems to set
     */
    public void setLayoutNameItems(List<Map<String, String>> layoutNameItems) {
        this.layoutNameItems = layoutNameItems;
    }

    public String getDesktopTheme() {
        return desktopTheme;
    }

    public void setDesktopTheme(String desktopTheme) {
        this.desktopTheme = desktopTheme;
    }

    public List<Map<String, String>> getDesktopThemeItems() {
        return desktopThemeItems;
    }

    public void setDesktopThemeItems(List<Map<String, String>> desktopThemeItems) {
        this.desktopThemeItems = desktopThemeItems;
    }

    public boolean isFolderOrPageHidden() {
        return folderOrPageHidden;
    }

    public void setFolderOrPageHidden(boolean folderOrPageHidden) {
        this.folderOrPageHidden = folderOrPageHidden;
    }

    public String getFolderOrPageName() {
        return folderOrPageName;
    }

    public void setFolderOrPageName(String folderOrPageName) {
        this.folderOrPageName = folderOrPageName;
    }

    public String getFolderOrPageShortTitle() {
        return folderOrPageShortTitle;
    }

    public void setFolderOrPageShortTitle(String folderOrPageShortTitle) {
        this.folderOrPageShortTitle = folderOrPageShortTitle;
    }

    public String getFolderOrPageTitle() {
        return folderOrPageTitle;
    }

    public void setFolderOrPageTitle(String folderOrPageTitle) {
        this.folderOrPageTitle = folderOrPageTitle;
    }

    public String getPageDecorator() {
        return pageDecorator;
    }

    public void setPageDecorator(String pageDecorator) {
        this.pageDecorator = pageDecorator;
    }

    public List<Map<String, String>> getPageDecoratorItems() {
        return pageDecoratorItems;
    }

    public void setPageDecoratorItems(
            List<Map<String, String>> pageDecoratorItems) {
        this.pageDecoratorItems = pageDecoratorItems;
    }

    public String getPortletDecorator() {
        return portletDecorator;
    }

    public void setPortletDecorator(String portletDecorator) {
        this.portletDecorator = portletDecorator;
    }

    public List<Map<String, String>> getPortletDecoratorItems() {
        return portletDecoratorItems;
    }

    public void setPortletDecoratorItems(
            List<Map<String, String>> portletDecoratorItems) {
        this.portletDecoratorItems = portletDecoratorItems;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/");
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.PAGE) {
            return PageInfoEditorPage.class;
        } else if (type == NodeInfo.LAYOUT) {
            return LayoutInfoEditorPage.class;
        }

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddFolder() {
        try {
            getSiteEditorService().addFolder(this);
            FacesMessageUtil.addInfoMessage("added.folder");
            return FolderAddFolderAndPageEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.folder");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddPage() {
        try {
            getSiteEditorService().addPage(this);
            FacesMessageUtil.addInfoMessage("added.page");
            return FolderAddFolderAndPageEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.page");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

}
