/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class FolderInfoEditorPage extends AbstractSiteEditorPage implements
        Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 7317388711533222091L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(FolderInfoEditorPage.class);

    private String desktopTheme;

    private List<Map<String, String>> desktopThemeItems;

    private String pageDecorator;

    private List<Map<String, String>> pageDecoratorItems;

    private boolean folderHidden;

    private String folderShortTitle;

    private String folderTitle;

    private String portletDecorator;

    private List<Map<String, String>> portletDecoratorItems;

    public String getDesktopTheme() {
        return desktopTheme;
    }

    public void setDesktopTheme(String desktopTheme) {
        this.desktopTheme = desktopTheme;
    }

    public List<Map<String, String>> getDesktopThemeItems() {
        return desktopThemeItems;
    }

    public void setDesktopThemeItems(List<Map<String, String>> desktopThemeItems) {
        this.desktopThemeItems = desktopThemeItems;
    }

    public String getPageDecorator() {
        return pageDecorator;
    }

    public void setPageDecorator(String folderDecorator) {
        this.pageDecorator = folderDecorator;
    }

    public List<Map<String, String>> getPageDecoratorItems() {
        return pageDecoratorItems;
    }

    public void setPageDecoratorItems(
            List<Map<String, String>> folderDecoratorItems) {
        this.pageDecoratorItems = folderDecoratorItems;
    }

    public String getFolderShortTitle() {
        return folderShortTitle;
    }

    public void setFolderShortTitle(String folderShortTitle) {
        this.folderShortTitle = folderShortTitle;
    }

    public String getFolderTitle() {
        return folderTitle;
    }

    public void setFolderTitle(String folderTitle) {
        this.folderTitle = folderTitle;
    }

    public String getPortletDecorator() {
        return portletDecorator;
    }

    public void setPortletDecorator(String portletDecorator) {
        this.portletDecorator = portletDecorator;
    }

    public List<Map<String, String>> getPortletDecoratorItems() {
        return portletDecoratorItems;
    }

    public void setPortletDecoratorItems(
            List<Map<String, String>> portletDecoratorItems) {
        this.portletDecoratorItems = portletDecoratorItems;
    }

    /**
     * @return the folderHidden
     */
    public boolean isFolderHidden() {
        return folderHidden;
    }

    /**
     * @param folderHidden the folderHidden to set
     */
    public void setFolderHidden(boolean folderHidden) {
        this.folderHidden = folderHidden;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/");
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.PAGE) {
            return PageInfoEditorPage.class;
        } else if (type == NodeInfo.LAYOUT) {
            return LayoutInfoEditorPage.class;
        }

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doUpdate() {
        try {
            getSiteEditorService().updateFolder(this);
            FacesMessageUtil.addInfoMessage("updated.folder");
            return FolderInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.update.folder");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doDelete() {
        try {
            getSiteEditorService().deleteFolder(this);
            FacesMessageUtil.addInfoMessage("deleted.folder");
            return FolderInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.delete.folder");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

}
