package jp.sf.pal.admin.web.site;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class FolderSecurityEditorPage extends AbstractSiteSecurityEditorPage
        implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -8992530845130742843L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(FolderSecurityEditorPage.class);

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/");
            return FolderInfoEditorPage.class;
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.PAGE) {
            return PageInfoEditorPage.class;
        } else if (type == NodeInfo.LAYOUT) {
            return LayoutInfoEditorPage.class;
        }

        if (getApplyOrder() != null && getSecurityConstraintType() != null
                && "delete".equals(getAction())) {
            // delete
            if (PALAdminConstants.SECURITY_CONSTRAINT
                    .equals(getSecurityConstraintType())) {
                doRemoveConstraint();
            } else if (PALAdminConstants.SECURITY_CONSTRAINTS_REF
                    .equals(getSecurityConstraintType())) {
                doRemoveConstraintRef();
            }

            setApplyOrder(null);
            setSecurityConstraintType(null);
        }

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddConstraint() {
        try {
            getSiteEditorService().addConstraint(this);
            FacesMessageUtil.addInfoMessage("added.folder.security");
            return FolderSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.folder.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddConstraintRef() {
        try {
            getSiteEditorService().addConstraintRef(this);
            FacesMessageUtil.addInfoMessage("added.folder.security");
            return FolderSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.folder.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doRemoveConstraint() {
        try {
            getSiteEditorService().removeConstraint(this);
            FacesMessageUtil.addInfoMessage("removed.folder.security");
            return FolderSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil
                    .addErrorMessage("could.not.remove.folder.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doRemoveConstraintRef() {
        try {
            getSiteEditorService().removeConstraintRef(this);
            FacesMessageUtil.addInfoMessage("removed.folder.security");
            return FolderSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil
                    .addErrorMessage("could.not.remove.folder.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

}
