/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;
import org.seasar.teeda.extension.annotation.validator.Required;

public class PageInfoEditorPage extends AbstractSiteEditorPage implements
        Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 6200363396293790793L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(PageInfoEditorPage.class);

    private String pageTitle;

    private String pageShortTitle;

    private List<Map<String, String>> pageDecoratorItems;

    @Required
    private String pageDecorator;

    private List<Map<String, String>> portletDecoratorItems;

    @Required
    private String portletDecorator;

    private List<Map<String, String>> desktopThemeItems;

    private String desktopTheme;

    private boolean pageHidden;

    /**
     * @return the pageTitle
     */
    public String getPageTitle() {
        return pageTitle;
    }

    /**
     * @param pageTitle the pageTitle to set
     */
    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    /**
     * @return the pageShortTitle
     */
    public String getPageShortTitle() {
        return pageShortTitle;
    }

    /**
     * @param pageShortTitle the pageShortTitle to set
     */
    public void setPageShortTitle(String pageShortTitle) {
        this.pageShortTitle = pageShortTitle;
    }

    /**
     * @return the pageDecoratorItems
     */
    public List<Map<String, String>> getPageDecoratorItems() {
        return pageDecoratorItems;
    }

    /**
     * @param pageDecoratorItems the pageDecoratorItems to set
     */
    public void setPageDecoratorItems(
            List<Map<String, String>> pageDecoratorItems) {
        this.pageDecoratorItems = pageDecoratorItems;
    }

    /**
     * @return the pageDecorator
     */
    public String getPageDecorator() {
        return pageDecorator;
    }

    /**
     * @param pageDecorator the pageDecorator to set
     */
    public void setPageDecorator(String pageDecorator) {
        this.pageDecorator = pageDecorator;
    }

    /**
     * @return the portletDecoratorItems
     */
    public List<Map<String, String>> getPortletDecoratorItems() {
        return portletDecoratorItems;
    }

    /**
     * @param portletDecoratorItems the portletDecoratorItems to set
     */
    public void setPortletDecoratorItems(
            List<Map<String, String>> portletDecoratorItems) {
        this.portletDecoratorItems = portletDecoratorItems;
    }

    /**
     * @return the portletDecorator
     */
    public String getPortletDecorator() {
        return portletDecorator;
    }

    /**
     * @param portletDecorator the portletDecorator to set
     */
    public void setPortletDecorator(String portletDecorator) {
        this.portletDecorator = portletDecorator;
    }

    /**
     * @return the desktopItems
     */
    public List<Map<String, String>> getDesktopThemeItems() {
        return desktopThemeItems;
    }

    /**
     * @param desktopThemeItems the desktopItems to set
     */
    public void setDesktopThemeItems(List<Map<String, String>> desktopThemeItems) {
        this.desktopThemeItems = desktopThemeItems;
    }

    /**
     * @return the desktopTheme
     */
    public String getDesktopTheme() {
        return desktopTheme;
    }

    /**
     * @param desktopTheme the desktopTheme to set
     */
    public void setDesktopTheme(String desktopTheme) {
        this.desktopTheme = desktopTheme;
    }

    /**
     * @return the pageHidden
     */
    public boolean isPageHidden() {
        return pageHidden;
    }

    /**
     * @param pageHidden the pageHidden to set
     */
    public void setPageHidden(boolean pageHidden) {
        this.pageHidden = pageHidden;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/default-page.psml");
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.FOLDER) {
            return FolderInfoEditorPage.class;
        } else if (type == NodeInfo.LAYOUT) {
            return LayoutInfoEditorPage.class;
        }

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doUpdate() {
        try {
            getSiteEditorService().updatePage(this);
            FacesMessageUtil.addInfoMessage("updated.page");
            return PageInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.update.page");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doDelete() {
        try {
            getSiteEditorService().deletePage(this);
            FacesMessageUtil.addInfoMessage("deleted.page");
            return FolderInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.delete.page");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

}
