/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class PageSecurityEditorPage extends AbstractSiteSecurityEditorPage
        implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 5074641483347337061L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(PageSecurityEditorPage.class);

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/default-page.psml");
            return PageInfoEditorPage.class;
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.FOLDER) {
            return FolderInfoEditorPage.class;
        } else if (type == NodeInfo.LAYOUT) {
            return LayoutInfoEditorPage.class;
        }

        if (getApplyOrder() != null && getSecurityConstraintType() != null
                && "delete".equals(getAction())) {
            // delete
            if (PALAdminConstants.SECURITY_CONSTRAINT
                    .equals(getSecurityConstraintType())) {
                doRemoveConstraint();
            } else if (PALAdminConstants.SECURITY_CONSTRAINTS_REF
                    .equals(getSecurityConstraintType())) {
                doRemoveConstraintRef();
            }

            setApplyOrder(null);
            setSecurityConstraintType(null);
        }

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddConstraint() {
        try {
            getSiteEditorService().addConstraint(this);
            FacesMessageUtil.addInfoMessage("added.page.security");
            return PageSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.page.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doAddConstraintRef() {
        try {
            getSiteEditorService().addConstraintRef(this);
            FacesMessageUtil.addInfoMessage("added.page.security");
            return PageSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.add.page.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doRemoveConstraint() {
        try {
            getSiteEditorService().removeConstraint(this);
            FacesMessageUtil.addInfoMessage("removed.page.security");
            return PageSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.remove.page.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doRemoveConstraintRef() {
        try {
            getSiteEditorService().removeConstraintRef(this);
            FacesMessageUtil.addInfoMessage("removed.page.security");
            return PageSecurityEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.remove.page.security");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

}
