/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.web.AbstractCrudPage;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;

public class UserRoleEditPage extends AbstractCrudPage implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 3675965027344869490L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserGroupEditPage.class);

    private String name;

    private List<Map<String, String>> newRoleItems;

    private int newRoleIndex;

    private String newRole;

    private List<Map<String, String>> rolesItems;

    private String[] roles;

    private UserManagementService userManagementService;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Map<String, String>> getNewRoleItems() {
        return newRoleItems;
    }

    public void setNewRoleItems(List<Map<String, String>> newRoleItems) {
        this.newRoleItems = newRoleItems;
    }

    public List<Map<String, String>> getRolesItems() {
        return rolesItems;
    }

    public void setRolesItems(List<Map<String, String>> rolesItems) {
        this.rolesItems = rolesItems;
    }

    /**
     * @return the newRole
     */
    public String getNewRole() {
        return newRole;
    }

    /**
     * @param newRole the newRole to set
     */
    public void setNewRole(String newRole) {
        this.newRole = newRole;
    }

    /**
     * @return the newRoleIndex
     */
    public int getNewRoleIndex() {
        return newRoleIndex;
    }

    /**
     * @param newRoleIndex the newRoleIndex to set
     */
    public void setNewRoleIndex(int newRoleIndex) {
        this.newRoleIndex = newRoleIndex;
    }

    /**
     * @return the roles
     */
    public String[] getRoles() {
        return roles;
    }

    /**
     * @param roles the roles to set
     */
    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService() {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public String initialize() {
        return null;
    }

    public String prerender() {
        // load page
        getUserManagementService().loadPage(this);

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    public String doAddRole() {
        if (getName() == null || getNewRole() == null) {
            FacesMessageUtil.addWarnMessage("invalid.role.or.user.name");
            return null;
        }

        // check if role exists
        if (getUserManagementService().isRoleExistsInUser(getName(),
                getNewRole())) {
            FacesMessageUtil.addWarnMessage("role.exists.in.user",
                    new Object[] { getName(), getNewRole() });
            return null;
        }

        try {
            getUserManagementService().addRoleToUser(this);
            FacesMessageUtil.addInfoMessage("added.role.to.user", new Object[] {
                    getName(), getNewRole() });

            // clear
            setNewRole(null);
        } catch (PALAdminException e) {
            FacesMessageUtil.addErrorMessage("failed.to.add.role.to.user",
                    new Object[] { getName(), getNewRole() });
            logger.error("Failed to add role to user. user=" + getName()
                    + ", role=" + getNewRole(), e);
        }
        return null;
    }

    public String doRemoveRole() {
        try {
            getUserManagementService().removeRolesFromUser(this);
            FacesMessageUtil.addInfoMessage("removed.roles.from.user",
                    new Object[] { getName(),
                            PALAdminUtil.toStringFromArray(getRoles()) });

            // clear
            setRoles(null);
        } catch (PALAdminException e) {
            FacesMessageUtil.addErrorMessage(
                    "failed.to.remove.roles.from.user", new Object[] {
                            getName(), getRoles() });
            logger.error("Failed to remove roles from user. user=" + getName()
                    + ", roles=" + getRoles(), e);
        }
        return null;
    }

    public boolean isRolesForUser() {
        return getRolesItems().size() > 0;
    }

}
