/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.seasar.framework.container.external.AbstractExternalContextMap;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;

public abstract class RebuildableExternalContextMap
extends AbstractExternalContextMap {
    protected WeakReference hotdeployClassLoader = new WeakReference<Object>(null);
    protected Set rebuiltNames = new HashSet(64);

    public Object get(Object key) {
        Object value = this.getAttribute(key.toString());
        if (value == null || !HotdeployUtil.isHotdeploy()) {
            return value;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof HotdeployClassLoader)) {
            return value;
        }
        if (currentLoader != this.hotdeployClassLoader.get()) {
            this.hotdeployClassLoader = new WeakReference<ClassLoader>(currentLoader);
            this.rebuiltNames.clear();
        }
        if (this.rebuiltNames.contains(key)) {
            return value;
        }
        Object rebuiltValue = HotdeployUtil.rebuildValue(value);
        this.rebuiltNames.add(key);
        this.setAttribute(key.toString(), rebuiltValue);
        return rebuiltValue;
    }
}

