/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.convention.impl;

import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;

public class PersistenceConventionImpl
implements PersistenceConvention {
    private String ignoreTablePrefix;
    private boolean noNameConversion = false;

    public String getIgnoreTablePrefix() {
        return this.ignoreTablePrefix;
    }

    public void setIgnoreTablePrefix(String ignoreTablePrefix) {
        this.ignoreTablePrefix = ignoreTablePrefix;
    }

    public boolean isNoNameConversion() {
        return this.noNameConversion;
    }

    public void setNoNameConversion(boolean noNameConversion) {
        this.noNameConversion = noNameConversion;
    }

    public String fromTableNameToEntityName(String tableName) {
        AssertionUtil.assertNotNull("tableName", tableName);
        if (this.noNameConversion) {
            return tableName;
        }
        return StringUtil.camelize(StringUtil.trimPrefix(tableName, this.ignoreTablePrefix));
    }

    public String fromEntityNameToTableName(String entityName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        if (this.noNameConversion) {
            return entityName;
        }
        String tableName = StringUtil.decamelize(entityName);
        if (this.ignoreTablePrefix != null) {
            tableName = this.ignoreTablePrefix + tableName;
        }
        return tableName;
    }

    public String fromColumnNameToPropertyName(String columnName) {
        AssertionUtil.assertNotNull("columnName", columnName);
        if (this.noNameConversion) {
            return columnName;
        }
        return StringUtil.decapitalize(StringUtil.camelize(columnName));
    }

    public String fromPropertyNameToColumnName(String propertyName) {
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.noNameConversion) {
            return propertyName;
        }
        return StringUtil.decamelize(propertyName);
    }
}

