/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleFacade;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ResourceUtil;

public class MessageResourceBundleFactory {
    private static final String PROPERTIES_EXT = ".properties";
    private static Map cache = new HashMap();

    public static MessageResourceBundle getBundle(String baseName) {
        return MessageResourceBundleFactory.getBundle(baseName, Locale.getDefault());
    }

    public static MessageResourceBundle getBundle(String baseName, Locale locale) throws ResourceNotFoundRuntimeException {
        MessageResourceBundle bundle = MessageResourceBundleFactory.getNullableBundle(baseName, locale);
        if (bundle != null) {
            return bundle;
        }
        throw new ResourceNotFoundRuntimeException(baseName);
    }

    public static MessageResourceBundle getNullableBundle(String baseName) {
        return MessageResourceBundleFactory.getNullableBundle(baseName, Locale.getDefault());
    }

    public static MessageResourceBundle getNullableBundle(String baseName, Locale locale) {
        AssertionUtil.assertNotNull("baseName", baseName);
        AssertionUtil.assertNotNull("locale", locale);
        String base = baseName.replace('.', '/');
        String path = base + "_" + locale.getLanguage() + PROPERTIES_EXT;
        MessageResourceBundleFacade facade = MessageResourceBundleFactory.loadFacade(path);
        String parentPath = base + PROPERTIES_EXT;
        MessageResourceBundleFacade parentFacade = MessageResourceBundleFactory.loadFacade(parentPath);
        if (facade != null && parentFacade != null) {
            facade.setParent(parentFacade);
            return facade.getBundle();
        }
        if (facade != null) {
            return facade.getBundle();
        }
        if (parentFacade != null) {
            return parentFacade.getBundle();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MessageResourceBundleFacade loadFacade(String path) {
        Map map = cache;
        synchronized (map) {
            MessageResourceBundleFacade facade = (MessageResourceBundleFacade)cache.get(path);
            if (facade != null) {
                return facade;
            }
            URL url = ResourceUtil.getResourceNoException(path);
            if (url != null) {
                facade = new MessageResourceBundleFacade(url);
                cache.put(path, facade);
                return facade;
            }
        }
        return null;
    }

    public static void clear() {
        cache.clear();
    }
}

