/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.seasar.framework.exception.IllegalAccessRuntimeException;

public final class FieldUtil {
    private FieldUtil() {
    }

    public static Object get(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static int getInt(Field field) throws IllegalAccessRuntimeException {
        return FieldUtil.getInt(field, null);
    }

    public static int getInt(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return field.getInt(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static String getString(Field field) throws IllegalAccessRuntimeException {
        return FieldUtil.getString(field, null);
    }

    public static String getString(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return (String)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static void set(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }
}

