/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.portlet.filter;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.portlet.util.RequestDumpUtil;

public class RequestDumpFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)(class$org$seasar$portlet$filter$RequestDumpFilter == null ? (class$org$seasar$portlet$filter$RequestDumpFilter = RequestDumpFilter.class$("org.seasar.portlet.filter.RequestDumpFilter")) : class$org$seasar$portlet$filter$RequestDumpFilter));
    private PortletFilterConfig config = null;
    private boolean beforeRequestParameter;
    private boolean afterRequestParameter;
    private boolean beforeRequestAttribute;
    private boolean afterRequestAttribute;
    private boolean beforeCookies;
    private boolean afterCookies;
    private boolean beforeRequestHeader;
    private boolean afterRequestHeader;
    private boolean beforeSessionAttribute;
    private boolean afterSessionAttribute;
    private boolean beforeContextAttribute;
    private boolean afterContextAttribute;
    private boolean afterResponse;
    private static final String INDENT = "  ";
    private static final String LF = System.getProperty("line.separator");
    static /* synthetic */ Class class$org$seasar$portlet$filter$RequestDumpFilter;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        this.config = filterConfig;
        this.beforeRequestParameter = this.getBooleanParameter(filterConfig, "beforeRequestParameter", true);
        this.afterRequestParameter = this.getBooleanParameter(filterConfig, "afterRequestParameter", false);
        this.beforeRequestAttribute = this.getBooleanParameter(filterConfig, "beforeRequestAttribute", true);
        this.afterRequestAttribute = this.getBooleanParameter(filterConfig, "afterRequestAttribute", true);
        this.beforeRequestHeader = this.getBooleanParameter(filterConfig, "beforeRequestHeader", true);
        this.afterRequestHeader = this.getBooleanParameter(filterConfig, "afterRequestHeader", false);
        this.beforeContextAttribute = this.getBooleanParameter(filterConfig, "beforeContextAttribute", true);
        this.afterContextAttribute = this.getBooleanParameter(filterConfig, "afterContextAttribute", true);
        this.beforeCookies = this.getBooleanParameter(filterConfig, "beforeCookies", true);
        this.afterCookies = this.getBooleanParameter(filterConfig, "afterCookies", true);
        this.beforeSessionAttribute = this.getBooleanParameter(filterConfig, "beforeSessionAttribute", true);
        this.afterSessionAttribute = this.getBooleanParameter(filterConfig, "afterSessionAttribute", true);
        this.afterResponse = this.getBooleanParameter(filterConfig, "afterResponse", true);
        StringBuffer sb = new StringBuffer();
        RequestDumpUtil.dumpContextProperties(sb, filterConfig.getPortletConfig().getPortletContext(), LF, INDENT);
        log.debug((Object)sb.toString());
    }

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws IOException, PortletException {
        if (this.config == null) {
            return;
        }
        this.dumpBefore((PortletRequest)request);
        try {
            chain.processActionFilter(request, response);
        }
        finally {
            this.dumpAfter((PortletRequest)request, (PortletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws IOException, PortletException {
        if (this.config == null) {
            return;
        }
        this.dumpBefore((PortletRequest)request);
        try {
            chain.renderFilter(request, response);
        }
        finally {
            this.dumpAfter((PortletRequest)request, (PortletResponse)response);
        }
    }

    private void dumpBefore(PortletRequest request) {
        PortletContext context = this.config.getPortletConfig().getPortletContext();
        StringBuffer sb = new StringBuffer();
        sb.append(LF);
        sb.append(LF);
        sb.append("** before *****************************************: ");
        sb.append(this.gerContextPath(request));
        sb.append(LF);
        RequestDumpUtil.dumpRequestProperties(sb, request, LF, INDENT);
        RequestDumpUtil.dumpSessionProperties(sb, request, LF, INDENT);
        if (this.beforeRequestParameter) {
            RequestDumpUtil.dumpRequestParameters(sb, request, LF, INDENT);
        }
        if (this.beforeRequestAttribute) {
            RequestDumpUtil.dumpRequestAttributes(sb, request, LF, INDENT);
        }
        if (this.beforeCookies) {
            RequestDumpUtil.dumpCookies(sb, request, LF, INDENT);
        }
        if (this.beforeRequestHeader) {
            RequestDumpUtil.dumpRequestHeaders(sb, request, LF, INDENT);
        }
        if (this.beforeSessionAttribute) {
            RequestDumpUtil.dumpSessionAttributes(sb, request, LF, INDENT);
        }
        if (this.beforeContextAttribute) {
            RequestDumpUtil.dumpContextAttributes(sb, context, LF, INDENT);
        }
        log.debug((Object)sb.toString());
    }

    private void dumpAfter(PortletRequest request, PortletResponse response) {
        StringBuffer sb = new StringBuffer();
        sb.append(LF);
        sb.append(LF);
        sb.append("** after *****************************************: ");
        sb.append(this.gerContextPath(request));
        sb.append(LF);
        if (this.afterResponse) {
            RequestDumpUtil.dumpResponseProperties(sb, response, LF, INDENT);
        }
        if (this.afterRequestParameter) {
            RequestDumpUtil.dumpRequestParameters(sb, request, LF, INDENT);
        }
        if (this.afterRequestAttribute) {
            RequestDumpUtil.dumpRequestAttributes(sb, request, LF, INDENT);
        }
        if (this.afterCookies) {
            RequestDumpUtil.dumpCookies(sb, request, LF, INDENT);
        }
        if (this.afterRequestHeader) {
            RequestDumpUtil.dumpRequestHeaders(sb, request, LF, INDENT);
        }
        if (this.afterSessionAttribute) {
            RequestDumpUtil.dumpSessionAttributes(sb, request, LF, INDENT);
        }
        if (this.afterContextAttribute) {
            RequestDumpUtil.dumpContextAttributes(sb, this.config.getPortletConfig().getPortletContext(), LF, INDENT);
        }
        log.debug((Object)sb.toString());
    }

    private String gerContextPath(PortletRequest request) {
        return request.getContextPath();
    }

    public String toString() {
        if (this.config == null) {
            return "RequestDumpFilter()";
        }
        StringBuffer sb = new StringBuffer("RequestDumpFilter(");
        sb.append(this.config);
        sb.append(")");
        return sb.toString();
    }

    private boolean getBooleanParameter(PortletFilterConfig filterConfig, String name, boolean defaultValue) {
        String value = filterConfig.getInitParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

