/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.extension.dbcp.impl.ConnectionWrapperImpl;
import org.seasar.extension.timer.TimeoutManager;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SLinkedList;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;

public class ConnectionPoolImpl
implements ConnectionPool,
Synchronization {
    public static final String readOnly_BINDING = "bindingType=may";
    public static final String transactionIsolationLevel_BINDING = "bindingType=may";
    public static final int DEFAULT_TRANSACTION_ISOLATION_LEVEL = -1;
    private static Logger logger = Logger.getLogger((Class)ConnectionPoolImpl.class);
    private XADataSource xaDataSource;
    private TransactionManager transactionManager;
    private int timeout = 600;
    private int maxPoolSize = 10;
    private boolean allowLocalTx = true;
    private boolean readOnly = false;
    private int transactionIsolationLevel = -1;
    private Set activePool = new HashSet();
    private Map txActivePool = new HashMap();
    private SLinkedList freePool = new SLinkedList();
    private TimeoutTask timeoutTask = TimeoutManager.getInstance().addTimeoutTarget(new TimeoutTarget(){

        public void expired() {
        }
    }, Integer.MAX_VALUE, true);

    public XADataSource getXADataSource() {
        return this.xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public boolean isAllowLocalTx() {
        return this.allowLocalTx;
    }

    public void setAllowLocalTx(boolean allowLocalTx) {
        this.allowLocalTx = allowLocalTx;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public int getActivePoolSize() {
        return this.activePool.size();
    }

    public int getTxActivePoolSize() {
        return this.txActivePool.size();
    }

    public int getFreePoolSize() {
        return this.freePool.size();
    }

    public synchronized ConnectionWrapper checkOut() throws SQLException {
        Transaction tx = this.getTransaction();
        if (tx == null && !this.isAllowLocalTx()) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        ConnectionWrapper con = this.getConnectionTxActivePool(tx);
        if (con != null) {
            return con;
        }
        while (this.getMaxPoolSize() > 0 && this.getActivePoolSize() + this.getTxActivePoolSize() >= this.getMaxPoolSize()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        con = this.checkOutFreePool();
        if (con == null) {
            con = this.createConnection(tx == null);
        } else {
            con.init(tx == null);
        }
        if (tx != null) {
            TransactionUtil.enlistResource((Transaction)tx, (XAResource)con.getXAResource());
            TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)this);
            this.setConnectionTxActivePool(tx, con);
        } else {
            this.setConnectionActivePool(con);
        }
        con.setReadOnly(this.readOnly);
        if (this.transactionIsolationLevel != -1) {
            con.setTransactionIsolation(this.transactionIsolationLevel);
        }
        return con;
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.transactionManager);
    }

    private ConnectionWrapper getConnectionTxActivePool(Transaction tx) {
        return (ConnectionWrapper)this.txActivePool.get(tx);
    }

    private ConnectionWrapper checkOutFreePool() {
        if (this.freePool.isEmpty()) {
            return null;
        }
        FreeItem item = (FreeItem)this.freePool.removeLast();
        ConnectionWrapper con = item.getConnection();
        item.destroy();
        return con;
    }

    private ConnectionWrapper createConnection(boolean localTx) throws SQLException {
        ConnectionWrapperImpl con = new ConnectionWrapperImpl(this.xaDataSource.getXAConnection(), this, localTx);
        logger.log("DSSR0006", null);
        return con;
    }

    private void setConnectionTxActivePool(Transaction tx, ConnectionWrapper connection) {
        this.txActivePool.put(tx, connection);
    }

    private void setConnectionActivePool(ConnectionWrapper connection) {
        this.activePool.add(connection);
    }

    public synchronized void release(ConnectionWrapper connection) {
        this.activePool.remove(connection);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.txActivePool.remove(tx);
        }
        connection.closeReally();
        this.notify();
    }

    public synchronized void checkIn(ConnectionWrapper connection) {
        this.activePool.remove(connection);
        connection.cleanup();
        if (this.getMaxPoolSize() > 0) {
            this.checkInFreePool(connection);
            this.notify();
        } else {
            connection.closeReally();
        }
    }

    private void checkInFreePool(ConnectionWrapper connection) {
        this.freePool.addLast((Object)new FreeItem(connection));
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 3: 
            case 4: {
                this.checkInTx();
            }
        }
    }

    private synchronized void checkInTx() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return;
        }
        ConnectionWrapper con = this.checkOutTxPool(tx);
        if (con == null) {
            return;
        }
        this.checkInFreePool(con);
        this.notify();
    }

    private ConnectionWrapper checkOutTxPool(Transaction tx) {
        return (ConnectionWrapper)this.txActivePool.remove(tx);
    }

    public final void beforeCompletion() {
    }

    public final synchronized void close() {
        ConnectionWrapper con;
        for (SLinkedList.Entry e = this.freePool.getFirstEntry(); e != null; e = e.getNext()) {
            FreeItem item = (FreeItem)e.getElement();
            item.getConnection().closeReally();
            item.destroy();
        }
        this.freePool.clear();
        Iterator<Object> i = this.txActivePool.values().iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.txActivePool.clear();
        i = this.activePool.iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.activePool.clear();
        this.timeoutTask.cancel();
    }

    private class FreeItem
    implements TimeoutTarget {
        private ConnectionWrapper connectionWrapper_;
        private TimeoutTask timeoutTask_;

        FreeItem(ConnectionWrapper connectionWrapper) {
            this.connectionWrapper_ = connectionWrapper;
            this.timeoutTask_ = TimeoutManager.getInstance().addTimeoutTarget(this, ConnectionPoolImpl.this.timeout, false);
        }

        public ConnectionWrapper getConnection() {
            return this.connectionWrapper_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            Object object = ConnectionPoolImpl.this;
            synchronized (object) {
                ConnectionPoolImpl.this.freePool.remove((Object)this);
            }
            object = this;
            synchronized (object) {
                if (this.timeoutTask_ != null) {
                    this.timeoutTask_.cancel();
                    this.timeoutTask_ = null;
                }
                if (this.connectionWrapper_ != null) {
                    this.connectionWrapper_.closeReally();
                    this.connectionWrapper_ = null;
                }
            }
        }

        public synchronized void destroy() {
            if (this.timeoutTask_ != null) {
                this.timeoutTask_.cancel();
                this.timeoutTask_ = null;
            }
            this.connectionWrapper_ = null;
        }
    }
}

