/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.seasar.extension.dbcp.impl.XAConnectionImpl;
import org.seasar.framework.util.DriverManagerUtil;
import org.seasar.framework.util.StringUtil;

public class XADataSourceImpl
implements XADataSource {
    private String driverClassName;
    private String url;
    private String user;
    private String password;
    private Properties properties = new Properties();

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        if (driverClassName != null && driverClassName.length() > 0) {
            DriverManagerUtil.registerDriver((String)driverClassName);
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.user, this.password);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Connection con = null;
        if (StringUtil.isEmpty((String)user)) {
            con = DriverManager.getConnection(this.url);
        } else if (this.properties.isEmpty()) {
            con = DriverManager.getConnection(this.url, user, password);
        } else {
            Properties info = new Properties();
            info.putAll((Map<?, ?>)this.properties);
            info.put("user", user);
            info.put("password", password);
            con = DriverManager.getConnection(this.url, info);
        }
        return new XAConnectionImpl(con);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
    }
}

