/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.util.StringUtil;

public class CalendarConverter
extends AbstractConverter {
    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Calendar.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat dateFormat;
        if (source == null) {
            return null;
        }
        if (source instanceof Calendar) {
            return source;
        }
        if (source instanceof Date) {
            return this.toCalendar((Date)source);
        }
        if (source instanceof Number) {
            return this.toCalendar((Number)source);
        }
        if (source instanceof String && (dateFormat = context.getDateFormat()) != null) {
            return this.toCalendar((String)source, dateFormat);
        }
        return null;
    }

    protected Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    protected Calendar toCalendar(Number date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date.longValue()));
        return cal;
    }

    protected Calendar toCalendar(String date, DateFormat dateFormat) {
        if (StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFormat.parse(date));
            return cal;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

