/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.converter.impl.ArrayConverter;
import org.seasar.extension.dxo.converter.impl.BeanConverter;
import org.seasar.extension.dxo.converter.impl.BigDecimalConverter;
import org.seasar.extension.dxo.converter.impl.BigIntegerConverter;
import org.seasar.extension.dxo.converter.impl.BooleanConverter;
import org.seasar.extension.dxo.converter.impl.ByteConverter;
import org.seasar.extension.dxo.converter.impl.CalendarConverter;
import org.seasar.extension.dxo.converter.impl.CharArrayConverter;
import org.seasar.extension.dxo.converter.impl.CharacterConverter;
import org.seasar.extension.dxo.converter.impl.DateConverter;
import org.seasar.extension.dxo.converter.impl.DoubleConverter;
import org.seasar.extension.dxo.converter.impl.FloatConverter;
import org.seasar.extension.dxo.converter.impl.IntegerConverter;
import org.seasar.extension.dxo.converter.impl.ListConverter;
import org.seasar.extension.dxo.converter.impl.LongConverter;
import org.seasar.extension.dxo.converter.impl.SetConverter;
import org.seasar.extension.dxo.converter.impl.ShortConverter;
import org.seasar.extension.dxo.converter.impl.SqlDateConverter;
import org.seasar.extension.dxo.converter.impl.SqlTimeConverter;
import org.seasar.extension.dxo.converter.impl.SqlTimestampConverter;
import org.seasar.extension.dxo.converter.impl.StringConverter;
import org.seasar.extension.dxo.converter.impl.TigerSupport;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class ConverterFactoryImpl
implements ConverterFactory,
Disposable {
    protected static final Converter[] BUILTIN_CONVERTERS = new Converter[]{new ArrayConverter(), new BeanConverter(), new BigDecimalConverter(), new BigIntegerConverter(), new BooleanConverter(), new ByteConverter(), new CalendarConverter(), new CharacterConverter(), new CharArrayConverter(), new DateConverter(), new DoubleConverter(), new FloatConverter(), new IntegerConverter(), new ListConverter(), new LongConverter(), new SetConverter(), new ShortConverter(), new SqlDateConverter(), new SqlTimeConverter(), new SqlTimestampConverter(), new StringConverter()};
    protected static final String[] BUILTIN_TIGER_CONVERTERS = new String[]{"org.seasar.extension.dxo.converter.impl.EnumConverter"};
    protected static Map PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY = new HashMap();
    protected boolean initialized;
    protected S2Container container;
    protected Converter[] converters;
    protected Map converterCache = new HashMap();

    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(100);
        list.addAll(Arrays.asList(BUILTIN_CONVERTERS));
        for (int i = 0; i < BUILTIN_TIGER_CONVERTERS.length; ++i) {
            try {
                list.add(Class.forName(BUILTIN_TIGER_CONVERTERS[i]).newInstance());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList(this.container.findAllComponents((Object)Converter.class)));
        this.converters = list.toArray(new Converter[list.size()]);
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        this.converters = null;
        this.converterCache.clear();
        this.initialized = false;
    }

    public Converter getConverter(Class sourceClass, Class destClass) {
        this.initialize();
        Class destType = ClassUtil.getWrapperClassIfPrimitive((Class)destClass);
        String cacheKey = sourceClass.getName() + destType.getName();
        Converter converter = (Converter)this.converterCache.get(cacheKey);
        if (converter != null) {
            return converter;
        }
        return this.detectConverter(sourceClass, destType);
    }

    private Converter detectConverter(Class sourceClass, Class destClass) {
        Converter converter = this.getDistanceTable(sourceClass, destClass);
        String cacheKey = sourceClass.getName() + destClass.getName();
        this.converterCache.put(cacheKey, converter);
        return converter;
    }

    private Converter getDistanceTable(Class sourceClass, Class destClass) {
        TreeMap<Double, Converter> distanceTable = new TreeMap<Double, Converter>();
        for (int i = 0; i < this.converters.length; ++i) {
            Converter converter = this.converters[i];
            if (!this.canConvert(sourceClass, destClass, converter)) continue;
            double distance = this.getDistance(converter.getDestClass(), destClass);
            distanceTable.put(new Double(distance), converter);
        }
        if (distanceTable.isEmpty()) {
            throw new IllegalStateException("converter\u3000was not found.");
        }
        return (Converter)distanceTable.values().iterator().next();
    }

    private boolean canConvert(Class sourceClass, Class destClass, Converter converter) {
        if (!converter.getDestClass().isAssignableFrom(destClass)) {
            Class wrapperArray = (Class)PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.get(destClass);
            if (wrapperArray != null) {
                return this.canConvert(sourceClass, wrapperArray, converter);
            }
            return false;
        }
        Class[] sourceClasses = converter.getSourceClasses();
        for (int i = 0; i < sourceClasses.length; ++i) {
            if (!sourceClasses[i].isAssignableFrom(sourceClass)) continue;
            return true;
        }
        return false;
    }

    private double getDistance(Class assigner, Class assignee) {
        if (assignee.isArray() && assigner.isArray()) {
            return this.getDistance(assigner.getComponentType(), assignee.getComponentType(), 0.0);
        }
        if (assignee.isArray()) {
            return this.getDistance(assigner, assignee, 10.0);
        }
        return this.getDistance(assigner, assignee, 0.0);
    }

    private double getDistance(Class assigner, Class assignee, double distance) {
        if (assignee.equals(assigner)) {
            return distance;
        }
        if (assigner.getName().equals("java.lang.Enum") && TigerSupport.instance.isEnum(assignee)) {
            return distance + 0.5;
        }
        if (this.isImplements(assigner, assignee)) {
            return distance + 0.5;
        }
        Class superClass = assigner.getSuperclass();
        if (superClass == null) {
            return distance + 1.0;
        }
        return this.getDistance(superClass, assignee, distance + 1.0);
    }

    private boolean isImplements(Class assigner, Class assignee) {
        return !assigner.isInterface() && assignee.isInterface() && assignee.isAssignableFrom(assigner);
    }

    static {
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([Z.class, Boolean;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([C.class, Character;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([B.class, Byte;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([S.class, Short;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([I.class, Integer;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([J.class, Long;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([F.class, Float;.class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put([D.class, Double;.class);
    }
}

