/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.SqlLogRegistry;
import org.seasar.extension.jdbc.SqlLogRegistryLocator;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.impl.SqlLogImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;

public class BasicHandler {
    private DataSource dataSource_;
    private String sql_;
    private StatementFactory statementFactory_ = BasicStatementFactory.INSTANCE;
    protected Class loggerClass = BasicHandler.class;

    public BasicHandler() {
    }

    public BasicHandler(DataSource ds, String sql) {
        this(ds, sql, BasicStatementFactory.INSTANCE);
    }

    public BasicHandler(DataSource ds, String sql, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setStatementFactory(statementFactory);
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public String getSql() {
        return this.sql_;
    }

    public void setSql(String sql) {
        this.sql_ = sql;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory_;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory_ = statementFactory;
    }

    protected Connection getConnection() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return DataSourceUtil.getConnection(this.dataSource_);
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        if (this.sql_ == null) {
            throw new EmptyRuntimeException("sql");
        }
        return this.statementFactory_.createPreparedStatement(connection, this.sql_);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class[] argTypes) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            ValueType valueType = this.getValueType(argTypes[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
                continue;
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    protected Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected String getCompleteSql(Object[] args) {
        if (args == null || args.length == 0) {
            return this.sql_;
        }
        StringBuffer buf = new StringBuffer(200);
        int pos = 0;
        int pos2 = 0;
        int pos3 = 0;
        int pos4 = 0;
        int pos5 = 0;
        int pos6 = 0;
        int index = 0;
        while (true) {
            pos = this.sql_.indexOf(63, pos2);
            pos3 = this.sql_.indexOf(39, pos2);
            pos4 = this.sql_.indexOf(39, pos3 + 1);
            pos5 = this.sql_.indexOf("/*", pos2);
            pos6 = this.sql_.indexOf("*/", pos5 + 1);
            if (pos <= 0) break;
            if (pos3 >= 0 && pos3 < pos && pos < pos4) {
                buf.append(this.sql_.substring(pos2, pos4 + 1));
                pos2 = pos4 + 1;
                continue;
            }
            if (pos5 >= 0 && pos5 < pos && pos < pos6) {
                buf.append(this.sql_.substring(pos2, pos6 + 1));
                pos2 = pos6 + 1;
                continue;
            }
            buf.append(this.sql_.substring(pos2, pos));
            buf.append(this.getBindVariableText(args[index++]));
            pos2 = pos + 1;
        }
        buf.append(this.sql_.substring(pos2));
        return buf.toString();
    }

    protected String getBindVariableText(Object bindVariable) {
        return BindVariableUtil.getBindVariableText(bindVariable);
    }

    protected ValueType getValueType(Class clazz) {
        return ValueTypes.getValueType(clazz);
    }

    protected void logSql(Object[] args, Object[] argTypes) {
        Logger logger = Logger.getLogger((Class)this.loggerClass);
        SqlLogRegistry sqlLogRegistry = SqlLogRegistryLocator.getInstance();
        if (logger.isDebugEnabled() || sqlLogRegistry != null) {
            String completeSql = this.getCompleteSql(args);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)completeSql);
            }
            if (sqlLogRegistry != null) {
                SqlLogImpl sqlLog = new SqlLogImpl(this.getSql(), completeSql, args, argTypes);
                sqlLogRegistry.add(sqlLog);
            }
        }
    }

    public Class getLoggerClass() {
        return this.loggerClass;
    }

    public void setLoggerClass(Class loggerClass) {
        this.loggerClass = loggerClass;
    }
}

