/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.ValueType;

public class BinaryType
implements ValueType {
    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        try {
            return this.toByteArray(resultSet.getBlob(index));
        }
        catch (SQLException e) {
            return resultSet.getBytes(index);
        }
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        try {
            return this.toByteArray(resultSet.getBlob(columnName));
        }
        catch (SQLException e) {
            return resultSet.getBytes(columnName);
        }
    }

    private byte[] toByteArray(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        long l = blob.length();
        if (Integer.MAX_VALUE < l) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return blob.getBytes(1L, (int)l);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -2);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            ps.setBinaryStream(index, (InputStream)in, ba.length);
        } else {
            ps.setObject(index, value);
        }
    }
}

