/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.util.MethodUtil;

public class UserDefineType
implements ValueType {
    private ValueType baseValueType;
    private Method valueOfMethod;
    private Method valueMethod;

    public UserDefineType(ValueType baseValueType, Method valueOfMethod, Method valueMethod) {
        this.baseValueType = baseValueType;
        this.valueOfMethod = valueOfMethod;
        this.valueMethod = valueMethod;
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.fromDbToJava(this.baseValueType.getValue(resultSet, index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.fromDbToJava(this.baseValueType.getValue(resultSet, columnName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        this.baseValueType.bindValue(ps, index, this.fromJavaToDb(value));
    }

    private Object fromDbToJava(Object value) {
        if (value == null) {
            return null;
        }
        return MethodUtil.invoke((Method)this.valueOfMethod, null, (Object[])new Object[]{value});
    }

    private Object fromJavaToDb(Object value) {
        if (value == null) {
            return null;
        }
        return MethodUtil.invoke((Method)this.valueMethod, (Object)value, null);
    }
}

