/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.BigDecimalType;
import org.seasar.extension.jdbc.types.BinaryStreamType;
import org.seasar.extension.jdbc.types.BinaryType;
import org.seasar.extension.jdbc.types.BooleanType;
import org.seasar.extension.jdbc.types.CharacterType;
import org.seasar.extension.jdbc.types.DoubleType;
import org.seasar.extension.jdbc.types.FloatType;
import org.seasar.extension.jdbc.types.IntegerType;
import org.seasar.extension.jdbc.types.LongType;
import org.seasar.extension.jdbc.types.ObjectType;
import org.seasar.extension.jdbc.types.ShortType;
import org.seasar.extension.jdbc.types.SqlDateType;
import org.seasar.extension.jdbc.types.StringType;
import org.seasar.extension.jdbc.types.TimeType;
import org.seasar.extension.jdbc.types.TimestampType;
import org.seasar.extension.jdbc.types.UserDefineType;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ModifierUtil;

public final class ValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType OBJECT = new ObjectType();
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map types = new HashMap();
    private static Constructor enumTypeConstructor;
    private static Method isEnumMethod;

    private ValueTypes() {
    }

    public static void registerValueType(Class clazz, ValueType valueType) {
        types.put(clazz, valueType);
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return ValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class clazz) {
        if (clazz == null) {
            return OBJECT;
        }
        for (Class c = clazz; c != null && c != (class$java$lang$Object == null ? ValueTypes.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
            ValueType valueType = ValueTypes.getValueType0(c);
            if (valueType == null) continue;
            return valueType;
        }
        if (enumTypeConstructor != null && isEnumMethod != null && MethodUtil.invoke((Method)isEnumMethod, (Object)clazz, null).equals(Boolean.TRUE)) {
            return (ValueType)ConstructorUtil.newInstance((Constructor)enumTypeConstructor, (Object[])new Class[]{clazz});
        }
        ValueType valueType = ValueTypes.createUserDefineValueType(clazz);
        if (valueType != null) {
            return valueType;
        }
        return OBJECT;
    }

    private static ValueType getValueType0(Class clazz) {
        return (ValueType)types.get(clazz);
    }

    private static ValueType createUserDefineValueType(Class clazz) {
        int i;
        ArrayList<Method> valueOfMethods = new ArrayList<Method>();
        Method valueMethod = null;
        Method[] methods = clazz.getMethods();
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int mod = method.getModifiers();
            if (method.getName().equals("valueOf") && method.getParameterTypes().length == 1 && ModifierUtil.isPublic((int)mod) && ModifierUtil.isStatic((int)mod)) {
                valueOfMethods.add(method);
                continue;
            }
            if (!method.getName().equals("value") || method.getParameterTypes().length != 0 || !ModifierUtil.isPublic((int)mod) || ModifierUtil.isStatic((int)mod)) continue;
            valueMethod = method;
        }
        if (valueMethod == null) {
            return null;
        }
        for (i = 0; i < valueOfMethods.size(); ++i) {
            Method valueOfMethod = (Method)valueOfMethods.get(i);
            if (valueOfMethod.getParameterTypes()[0] != valueMethod.getReturnType()) continue;
            Class<?> baseClass = valueMethod.getReturnType();
            ValueType baseValueType = ValueTypes.getValueType0(baseClass);
            if (baseValueType == null) {
                return null;
            }
            return new UserDefineType(baseValueType, valueOfMethod, valueMethod);
        }
        return null;
    }

    public static Class getType(int sqltype) {
        switch (sqltype) {
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public static ValueType getValueType(int sqltype) {
        return ValueTypes.getValueType(ValueTypes.getType(sqltype));
    }

    static {
        ValueTypes.registerValueType(String.class, STRING);
        ValueTypes.registerValueType(Character.TYPE, CHARACTER);
        ValueTypes.registerValueType(Character.class, CHARACTER);
        ValueTypes.registerValueType(Short.TYPE, SHORT);
        ValueTypes.registerValueType(Short.class, SHORT);
        ValueTypes.registerValueType(Integer.TYPE, INTEGER);
        ValueTypes.registerValueType(Integer.class, INTEGER);
        ValueTypes.registerValueType(Long.TYPE, LONG);
        ValueTypes.registerValueType(Long.class, LONG);
        ValueTypes.registerValueType(Float.TYPE, FLOAT);
        ValueTypes.registerValueType(Float.class, FLOAT);
        ValueTypes.registerValueType(Double.TYPE, DOUBLE);
        ValueTypes.registerValueType(Double.class, DOUBLE);
        ValueTypes.registerValueType(BigDecimal.class, BIGDECIMAL);
        ValueTypes.registerValueType(Date.class, SQLDATE);
        ValueTypes.registerValueType(Time.class, TIME);
        ValueTypes.registerValueType(java.util.Date.class, TIMESTAMP);
        ValueTypes.registerValueType(Timestamp.class, TIMESTAMP);
        ValueTypes.registerValueType(Calendar.class, TIMESTAMP);
        ValueTypes.registerValueType(BYTE_ARRAY_CLASS, BINARY);
        ValueTypes.registerValueType(InputStream.class, BINARY_STREAM);
        ValueTypes.registerValueType(Boolean.TYPE, BOOLEAN);
        ValueTypes.registerValueType(Boolean.class, BOOLEAN);
        try {
            isEnumMethod = Class.class.getMethod("isEnum", null);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName("org.seasar.extension.jdbc.types.EnumType");
            enumTypeConstructor = clazz.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

