/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.seasar.extension.jta.TransactionImpl;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SNotSupportedException;
import org.seasar.framework.exception.SSystemException;

public class TransactionManagerImpl
implements TransactionManager {
    private final ThreadLocal threadAttachTx = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            throw new SNotSupportedException("ESSR0316", null);
        }
        tx = this.attachTransaction();
        tx.begin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.commit();
        }
        finally {
            this.setCurrent(null);
        }
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.suspend();
        }
        catch (XAException ex) {
            throw new SSystemException("ESSR0363", new Object[]{ex}, (Throwable)ex);
        }
        finally {
            this.setCurrent(null);
        }
        return tx;
    }

    public void resume(Transaction resumeTx) throws InvalidTransactionException, IllegalStateException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        try {
            ((TransactionImpl)resumeTx).resume();
        }
        catch (XAException ex) {
            throw new SSystemException("ESSR0364", new Object[]{ex}, (Throwable)ex);
        }
        this.setCurrent((TransactionImpl)resumeTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.rollback();
        }
        finally {
            this.setCurrent(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }

    public int getStatus() {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.getCurrent();
    }

    private TransactionImpl getCurrent() {
        TransactionImpl tx = (TransactionImpl)this.threadAttachTx.get();
        if (tx != null && tx.getStatus() == 6) {
            this.setCurrent(null);
            return null;
        }
        return tx;
    }

    private void setCurrent(TransactionImpl current) {
        this.threadAttachTx.set(current);
    }

    private TransactionImpl attachTransaction() {
        TransactionImpl tx = (TransactionImpl)this.threadAttachTx.get();
        if (tx == null) {
            tx = new TransactionImpl();
            this.setCurrent(tx);
        }
        return tx;
    }
}

