/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.context.SqlContextImpl;
import org.seasar.extension.sql.node.ContainerNode;

public class AddWhereIfNode
extends ContainerNode {
    Pattern pat = Pattern.compile("\\s*(order\\sby)|$)");

    public void accept(SqlContext ctx) {
        SqlContextImpl childCtx = new SqlContextImpl(ctx);
        super.accept(childCtx);
        if (childCtx.isEnabled()) {
            String sql = childCtx.getSql();
            String completeSql = childCtx.getCompleteSql();
            Matcher m = this.pat.matcher(sql);
            if (!m.lookingAt()) {
                sql = " WHERE " + sql;
                completeSql = " WHERE " + completeSql;
            }
            ctx.addSql(sql, childCtx.getBindVariables(), childCtx.getBindVariableTypes());
            ctx.addCompleteSql(completeSql);
        }
    }
}

