/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.node;

import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.node.AbstractNode;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.StringUtil;

public class BindVariableNode
extends AbstractNode {
    private String expression;
    private String[] names;

    public BindVariableNode(String expression) {
        this.expression = expression;
        this.names = StringUtil.split((String)expression, (String)".");
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object value = ctx.getArg(this.names[0]);
        Class clazz = ctx.getArgType(this.names[0]);
        for (int pos = 1; pos < this.names.length; ++pos) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
            PropertyDesc pd = beanDesc.getPropertyDesc(this.names[pos]);
            if (value == null) break;
            value = pd.getValue(value);
            clazz = pd.getPropertyType();
        }
        ctx.addSql("?", value, clazz);
        ctx.addCompleteSql(BindVariableUtil.getBindVariableText(value));
    }
}

