/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SIllegalArgumentException;

public abstract class AbstractTxInterceptor
implements MethodInterceptor {
    public static final String userTransaction_BINDING = "bindingType=must";
    public static final String transactionManager_BINDING = "bindingType=may";
    private UserTransaction userTransaction;
    private TransactionManager transactionManager;
    private final List txRules = new ArrayList();
    static /* synthetic */ Class class$java$lang$Throwable;

    public final UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean hasTransaction() throws SystemException {
        return this.userTransaction.getStatus() != 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.userTransaction.begin();
    }

    public void end() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (this.userTransaction.getStatus() == 0) {
            this.userTransaction.commit();
        } else {
            this.userTransaction.rollback();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.hasTransaction()) {
            this.userTransaction.rollback();
        }
    }

    public Transaction suspend() throws SystemException {
        if (this.transactionManager == null) {
            throw new EmptyRuntimeException("transactionManager");
        }
        return this.transactionManager.suspend();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.transactionManager == null) {
            throw new EmptyRuntimeException("transactionManager");
        }
        this.transactionManager.resume(transaction);
    }

    public boolean complete(Throwable throwable) throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        for (int i = 0; i < this.txRules.size(); ++i) {
            TxRule rule = (TxRule)this.txRules.get(i);
            if (!rule.isAssignableFrom(throwable)) continue;
            return rule.complete();
        }
        this.rollback();
        return false;
    }

    public void addCommitRule(Class exceptionClass) {
        this.txRules.add(new TxRule(exceptionClass, true));
    }

    public void addRollbackRule(Class exceptionClass) {
        this.txRules.add(new TxRule(exceptionClass, false));
    }

    private class TxRule {
        private Class exceptionClass;
        private boolean commit;

        public TxRule(Class exceptionClass, boolean commit) {
            if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = AbstractTxInterceptor.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(exceptionClass)) {
                throw new SIllegalArgumentException("ESSR0365", new Object[]{exceptionClass.getName()});
            }
            this.exceptionClass = exceptionClass;
            this.commit = commit;
        }

        public boolean isAssignableFrom(Throwable t) {
            return this.exceptionClass.isAssignableFrom(t.getClass());
        }

        public boolean complete() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
            if (this.commit) {
                AbstractTxInterceptor.this.end();
            } else {
                AbstractTxInterceptor.this.rollback();
            }
            return this.commit;
        }
    }
}

