/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReader;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.unit.BeanListReader;
import org.seasar.extension.unit.BeanReader;
import org.seasar.extension.unit.MapListReader;
import org.seasar.extension.unit.MapReader;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;

public abstract class S2TestCase
extends S2FrameworkTestCase {
    private static final String DATASOURCE_NAME = "j2ee.dataSource";
    private DataSource dataSource;
    private Connection connection;
    private DatabaseMetaData dbMetaData;

    public S2TestCase() {
    }

    public S2TestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRunTest() throws Throwable {
        TransactionManager tm = null;
        if (this.needTransaction()) {
            try {
                tm = (TransactionManager)this.getComponent(TransactionManager.class);
                tm.begin();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        try {
            super.doRunTest();
        }
        finally {
            if (tm != null) {
                tm.rollback();
            }
        }
    }

    protected boolean needTransaction() {
        return this.getName().endsWith("Tx");
    }

    protected void setUpAfterContainerInit() throws Throwable {
        super.setUpAfterContainerInit();
        this.setupDataSource();
    }

    protected void tearDownBeforeContainerDestroy() throws Throwable {
        this.tearDownDataSource();
        super.tearDownBeforeContainerDestroy();
    }

    protected void setupDataSource() {
        S2Container container = this.getContainer();
        try {
            if (container.hasComponentDef((Object)DATASOURCE_NAME)) {
                this.dataSource = (DataSource)container.getComponent((Object)DATASOURCE_NAME);
            } else if (container.hasComponentDef((Object)DataSource.class)) {
                this.dataSource = (DataSource)container.getComponent((Object)DataSource.class);
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }

    protected void tearDownDataSource() {
        this.dbMetaData = null;
        if (this.connection != null) {
            ConnectionUtil.close(this.connection);
            this.connection = null;
        }
        this.dataSource = null;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return this.dataSource;
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = DataSourceUtil.getConnection(this.getDataSource());
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.dbMetaData != null) {
            return this.dbMetaData;
        }
        this.dbMetaData = ConnectionUtil.getMetaData(this.getConnection());
        return this.dbMetaData;
    }

    public DataSet readXls(String path) {
        return this.readXls(path, true);
    }

    public DataSet readXls(String path, boolean trimString) {
        XlsReader reader = new XlsReader(this.convertPath(path), trimString);
        return reader.read();
    }

    public void writeXls(String path, DataSet dataSet) {
        File dir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        File file = new File(dir, this.convertPath(path));
        XlsWriter writer = new XlsWriter(FileOutputStreamUtil.create((File)file));
        writer.write(dataSet);
    }

    public void writeDb(DataSet dataSet) {
        SqlWriter writer = this.getSqlWriter();
        writer.write(dataSet);
    }

    protected SqlWriter getSqlWriter() {
        S2Container container = this.getContainer();
        if (container.hasComponentDef((Object)SqlWriter.class)) {
            return (SqlWriter)container.getComponent((Object)SqlWriter.class);
        }
        return new SqlWriter(this.getDataSource());
    }

    public DataSet readDb(DataSet dataSet) {
        SqlReader reader = new SqlReader(this.getDataSource());
        reader.addDataSet(dataSet);
        return reader.read();
    }

    public DataTable readDbByTable(String table) {
        return this.readDbByTable(table, null);
    }

    public DataTable readDbByTable(String table, String condition) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setTable(table, condition);
        return reader.read();
    }

    public DataTable readDbBySql(String sql, String tableName) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setSql(sql, tableName);
        return reader.read();
    }

    public void readXlsWriteDb(String path) {
        this.readXlsWriteDb(path, true);
    }

    public void readXlsWriteDb(String path, boolean trimString) {
        this.writeDb(this.readXls(path, trimString));
    }

    public void readXlsReplaceDb(String path) {
        this.readXlsReplaceDb(path, true);
    }

    public void readXlsReplaceDb(String path, boolean trimString) {
        DataSet dataSet = this.readXls(path, trimString);
        this.deleteDb(dataSet);
        this.writeDb(dataSet);
    }

    public void readXlsAllReplaceDb(String path) {
        this.readXlsAllReplaceDb(path, true);
    }

    public void readXlsAllReplaceDb(String path, boolean trimString) {
        DataSet dataSet = this.readXls(path, trimString);
        for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
            this.deleteTable(dataSet.getTable(i).getTableName());
        }
        this.writeDb(dataSet);
    }

    public DataSet reload(DataSet dataSet) {
        return new SqlReloadReader(this.getDataSource(), dataSet).read();
    }

    public DataTable reload(DataTable table) {
        return new SqlReloadTableReader(this.getDataSource(), table).read();
    }

    public DataSet reloadOrReadDb(DataSet dataSet) {
        DataSetImpl newDataSet = new DataSetImpl();
        block0: for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DataTable table = dataSet.getTable(i);
            if (!table.hasMetaData()) {
                table.setupMetaData(this.getDatabaseMetaData());
            }
            int j = 0;
            while (i < table.getColumnSize()) {
                DataColumn column = table.getColumn(j);
                if (column.isPrimaryKey()) {
                    newDataSet.addTable(this.reload(table));
                    continue block0;
                }
                ++j;
            }
            newDataSet.addTable(this.readDbByTable(table.getTableName()));
        }
        return newDataSet;
    }

    public void deleteDb(DataSet dataSet) {
        SqlDeleteTableWriter writer = new SqlDeleteTableWriter(this.getDataSource());
        for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
            writer.write(dataSet.getTable(i));
        }
    }

    public void deleteTable(String tableName) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.getDataSource(), "DELETE FROM " + tableName);
        handler.execute(null);
    }

    public void assertEquals(DataSet expected, DataSet actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, DataSet actual) {
        message = message == null ? "" : message;
        S2TestCase.assertEquals((String)(message + ":TableSize"), (int)expected.getTableSize(), (int)actual.getTableSize());
        for (int i = 0; i < expected.getTableSize(); ++i) {
            this.assertEquals(message, expected.getTable(i), actual.getTable(i));
        }
    }

    public void assertEquals(DataTable expected, DataTable actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataTable expected, DataTable actual) {
        message = message == null ? "" : message;
        message = message + ":TableName=" + expected.getTableName();
        S2TestCase.assertEquals((String)(message + ":RowSize"), (int)expected.getRowSize(), (int)actual.getRowSize());
        for (int i = 0; i < expected.getRowSize(); ++i) {
            DataRow expectedRow = expected.getRow(i);
            DataRow actualRow = actual.getRow(i);
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (int j = 0; j < expected.getColumnSize(); ++j) {
                try {
                    String columnName = expected.getColumnName(j);
                    Object expectedValue = expectedRow.getValue(columnName);
                    ColumnType ct = ColumnTypes.getColumnType(expectedValue);
                    Object actualValue = actualRow.getValue(columnName);
                    if (ct.equals(expectedValue, actualValue)) continue;
                    S2TestCase.assertEquals((String)(message + ":Row=" + i + ":columnName=" + columnName), (Object)expectedValue, (Object)actualValue);
                    continue;
                }
                catch (AssertionFailedError e) {
                    errorMessages.add(e.getMessage());
                }
            }
            if (errorMessages.isEmpty()) continue;
            S2TestCase.fail((String)(message + errorMessages));
        }
    }

    public void assertEquals(DataSet expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, Object actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            return;
        }
        if (actual instanceof List) {
            List actualList = (List)actual;
            Assert.assertFalse((boolean)actualList.isEmpty());
            Object actualItem = actualList.get(0);
            if (actualItem instanceof Map) {
                this.assertMapListEquals(message, expected, actualList);
            } else {
                this.assertBeanListEquals(message, expected, actualList);
            }
        } else if (actual instanceof Object[]) {
            this.assertEquals(message, expected, Arrays.asList((Object[])actual));
        } else if (actual instanceof Map) {
            this.assertMapEquals(message, expected, (Map)actual);
        } else {
            this.assertBeanEquals(message, expected, actual);
        }
    }

    protected void assertMapEquals(String message, DataSet expected, Map map) {
        MapReader reader = new MapReader(map);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertMapListEquals(String message, DataSet expected, List list) {
        MapListReader reader = new MapListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        BeanReader reader = new BeanReader(bean);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        BeanListReader reader = new BeanListReader(list);
        this.assertEquals(message, expected, reader.read());
    }
}

