/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.tiger.AnnotationUtil;
import org.seasar.teeda.extension.annotation.convert.Converter;
import org.seasar.teeda.extension.annotation.handler.ConstantConverterAnnotationHandler;

public class TigerConverterAnnotationHandler
extends ConstantConverterAnnotationHandler {
    protected Class<? extends Annotation> metaAnnotationType = Converter.class;

    protected void processField(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.processAnnotation(container, componentName, field.getName(), annotation);
        }
        super.processField(container, componentClass, componentName, namingConvention, beanDesc, field);
    }

    protected void processAnnotation(S2Container container, String componentName, String propertyName, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Annotation metaAnnotation = annotationType.getAnnotation(this.metaAnnotationType);
        if (metaAnnotation == null) {
            return;
        }
        String converterName = this.getConverterName(metaAnnotation);
        Map props = AnnotationUtil.getProperties((Annotation)annotation);
        this.registerConverter(componentName, propertyName, converterName, props);
    }

    protected void processGetterMethod(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, PropertyDesc propertyDesc) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = propertyDesc.getReadMethod().getDeclaredAnnotations()) {
            this.processAnnotation(container, componentName, propertyDesc.getPropertyName(), annotation);
        }
    }

    protected String getConverterName(Annotation annotation) {
        Class<? extends Annotation> annoType = annotation.annotationType();
        Method m = ClassUtil.getMethod(annoType, (String)"value", null);
        return (String)MethodUtil.invoke((Method)m, (Object)annotation, null);
    }
}

