/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class JSONSerializer {
    public static String serialize(Object o) {
        StringBuffer buf = new StringBuffer(100);
        JSONSerializer.appendSerializeObject(buf, o);
        return buf.toString();
    }

    public static void appendSerializeObject(StringBuffer buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o instanceof String) {
            buf.append(JSONSerializer.quote((String)o));
        } else if (o instanceof Float) {
            JSONSerializer.appendSerializeFloat(buf, (Float)o);
        } else if (o instanceof Double) {
            JSONSerializer.appendSerializeDouble(buf, (Double)o);
        } else if (o instanceof Number) {
            buf.append(o.toString());
        } else if (o instanceof Boolean) {
            JSONSerializer.appendSerializeBoolean(buf, (Boolean)o);
        } else if (o instanceof Collection) {
            JSONSerializer.appendSerializeArray(buf, ((Collection)o).toArray());
        } else if (o instanceof Object[]) {
            JSONSerializer.appendSerializeArray(buf, (Object[])o);
        } else if (o instanceof Map) {
            JSONSerializer.appendSerializeMap(buf, (Map)o);
        } else if (o.getClass().isArray()) {
            JSONSerializer.appendSerializeObjectArray(buf, o);
        } else {
            JSONSerializer.appendSerializeBean(buf, o);
        }
    }

    public static void appendSerializeFloat(StringBuffer buf, Float f) {
        if (f.isNaN() || f.isInfinite()) {
            throw new IllegalArgumentException(f.toString());
        }
        buf.append(f.toString());
    }

    public static void appendSerializeDouble(StringBuffer buf, Double d) {
        if (d.isNaN() || d.isInfinite()) {
            throw new IllegalArgumentException(d.toString());
        }
        buf.append(d.toString());
    }

    public static void appendSerializeBoolean(StringBuffer buf, Boolean b) {
        if (Boolean.TRUE.equals(b)) {
            buf.append("true");
        } else {
            buf.append("false");
        }
    }

    public static void appendSerializeArray(StringBuffer buf, Object[] array) {
        int length = array.length;
        buf.append("[");
        for (int i = 0; i < length; ++i) {
            JSONSerializer.appendSerializeObject(buf, array[i]);
            buf.append(",");
        }
        if (length > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
    }

    public static void appendSerializeMap(StringBuffer buf, Map map) {
        buf.append("{");
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buf.append(key + ":");
            JSONSerializer.appendSerializeObject(buf, map.get(key));
            buf.append(",");
        }
        if (map.size() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("}");
    }

    public static void appendSerializeBean(StringBuffer buf, Object bean) {
        buf.append("{");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            buf.append(pd.getPropertyName() + ":");
            JSONSerializer.appendSerializeObject(buf, pd.getValue(bean));
            buf.append(",");
        }
        if (beanDesc.getPropertyDescSize() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("}");
    }

    public static void appendSerializeObjectArray(StringBuffer buf, Object o) {
        int length = Array.getLength(o);
        buf.append("[");
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(o, i);
            JSONSerializer.appendSerializeObject(buf, value);
            buf.append(",");
        }
        if (length > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
    }

    public static String quote(String str) {
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        char current = '\u0000';
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(current);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (current < ' ') {
                        String t = "000" + Integer.toHexString(current);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(current);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static boolean isObject(String str) {
        return str.startsWith("{") && str.endsWith("}");
    }

    public static boolean isArray(String str) {
        return str.startsWith("[") && str.endsWith("]");
    }

    public static boolean isString(String str) {
        return str.startsWith("'") && str.endsWith("'");
    }

    public static Map evalMap(String str) {
        HashMap map = new HashMap();
        StringBuffer buf = new StringBuffer();
        String key = null;
        String value = null;
        boolean valueParse = false;
        int braceStart = 0;
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '{': {
                    if (!valueParse) continue block8;
                    buf.append(c);
                    ++braceStart;
                    continue block8;
                }
                case '}': {
                    if (!valueParse || braceStart <= 0) continue block8;
                    buf.append(c);
                    --braceStart;
                    continue block8;
                }
                case '[': {
                    if (!valueParse) continue block8;
                    buf.append(c);
                    ++braceStart;
                    continue block8;
                }
                case ']': {
                    if (!valueParse) continue block8;
                    buf.append(c);
                    --braceStart;
                    continue block8;
                }
                case ':': {
                    if (braceStart > 0) {
                        buf.append(c);
                        continue block8;
                    }
                    key = JSONSerializer.evalString(buf.toString().trim());
                    valueParse = true;
                    buf = new StringBuffer();
                    continue block8;
                }
                case ',': {
                    value = buf.toString().trim();
                    valueParse = false;
                    buf = new StringBuffer();
                    JSONSerializer.evalAndAddMap(key, value, map);
                    continue block8;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            value = buf.toString().trim();
        }
        JSONSerializer.evalAndAddMap(key, value, map);
        return map;
    }

    public static List evalArray(String str) {
        ArrayList list = new ArrayList();
        StringBuffer buf = new StringBuffer();
        String value = null;
        int braceStart = 0;
        block8: for (int i = 1; i < str.length() - 1; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '{': {
                    buf.append(c);
                    ++braceStart;
                    continue block8;
                }
                case '}': {
                    if (braceStart <= 0) continue block8;
                    buf.append(c);
                    --braceStart;
                    continue block8;
                }
                case '[': {
                    buf.append(c);
                    ++braceStart;
                    continue block8;
                }
                case ']': {
                    buf.append(c);
                    --braceStart;
                    continue block8;
                }
                case ':': {
                    if (braceStart <= 0) continue block8;
                    buf.append(c);
                    continue block8;
                }
                case ',': {
                    if (braceStart > 0) {
                        buf.append(c);
                        continue block8;
                    }
                    value = buf.toString().trim();
                    buf = new StringBuffer();
                    JSONSerializer.evalAndAddList(value, list);
                    continue block8;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            value = buf.toString().trim();
        }
        JSONSerializer.evalAndAddList(value, list);
        return list;
    }

    private static void evalAndAddList(String value, List list) {
        if (JSONSerializer.isObject(value)) {
            list.add(JSONSerializer.evalMap(value));
        } else if (JSONSerializer.isArray(value)) {
            list.add(JSONSerializer.evalArray(value));
        } else {
            Integer intValue = JSONSerializer.evalInt(value);
            if (intValue != null) {
                list.add(intValue);
            } else {
                list.add(JSONSerializer.evalString(value));
            }
        }
    }

    private static void evalAndAddMap(String key, String value, Map map) {
        if (JSONSerializer.isObject(value)) {
            Map v = JSONSerializer.evalMap(value);
            map.put(key, v);
        } else if (JSONSerializer.isArray(value)) {
            List list = JSONSerializer.evalArray(value);
            map.put(key, list);
        } else {
            Integer intValue = JSONSerializer.evalInt(value);
            if (intValue != null) {
                map.put(key, intValue);
            } else {
                map.put(key, JSONSerializer.evalString(value));
            }
        }
    }

    public static String evalString(String str) {
        if (JSONSerializer.isString(str)) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static Integer evalInt(String str) {
        try {
            int i = Integer.parseInt(str);
            return new Integer(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

