/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.DateConversionUtil;

public class DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    protected static final String STYLE_DEFAULT = "default";
    protected static final String STYLE_MEDIUM = "medium";
    protected static final String STYLE_SHORT = "short";
    protected static final String STYLE_LONG = "long";
    protected static final String STYLE_FULL = "full";
    protected static final String TYPE_DATE = "date";
    protected static final String TYPE_TIME = "time";
    protected static final String TYPE_BOTH = "both";
    private String dateStyle = "default";
    private boolean transientValue = false;
    private Locale locale = null;
    private String pattern = null;
    private String timeStyle = "default";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Locale locale = this.getLocale();
        DateFormat format = this.getDateFormat(value, locale);
        if (format == null) {
            format = DateConversionUtil.getDateFormat((String)value, (Locale)locale);
        }
        format.setLenient(false);
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        try {
            return format.parse(value);
        }
        catch (ParseException e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw ConvertUtil.wrappedByConverterException(this, context, args, e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        DateFormat formatter = this.getDateFormat(this.getLocale());
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            formatter.setTimeZone(timeZone);
        }
        try {
            return formatter.format(value);
        }
        catch (Exception e) {
            throw ConvertUtil.wrappedByConverterException(e);
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.dateStyle = (String)values[0];
        this.locale = (Locale)values[1];
        this.pattern = (String)values[2];
        this.timeStyle = (String)values[3];
        this.timeZone = (TimeZone)values[4];
        this.type = (String)values[5];
    }

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private Locale getLocale(FacesContext context) {
        return context.getViewRoot().getLocale();
    }

    protected DateFormat getDateFormat(Locale locale) {
        String pattern = this.getPattern();
        if (pattern != null) {
            return new SimpleDateFormat(pattern, locale);
        }
        if (this.isDefaultStyle()) {
            return DateConversionUtil.getY4DateFormat((Locale)locale);
        }
        return this.getDateFormatForType();
    }

    protected DateFormat getDateFormat(String value, Locale locale) {
        String pattern = this.getPattern();
        if (pattern != null) {
            return new SimpleDateFormat(pattern, locale);
        }
        if (this.isDefaultStyle()) {
            return DateConversionUtil.getDateFormat((String)value, (Locale)locale);
        }
        return this.getDateFormatForType();
    }

    protected boolean isDefaultStyle() {
        return TYPE_DATE.equalsIgnoreCase(this.getType()) && STYLE_DEFAULT.equalsIgnoreCase(this.getDateStyle()) && STYLE_DEFAULT.equalsIgnoreCase(this.getTimeStyle());
    }

    protected DateFormat getDateFormatForType() {
        String type = this.getType();
        if (type.equals(TYPE_DATE)) {
            return DateFormat.getDateInstance(this.calcStyle(this.getDateStyle()), this.getLocale());
        }
        if (type.equals(TYPE_TIME)) {
            return DateFormat.getTimeInstance(this.calcStyle(this.getTimeStyle()), this.getLocale());
        }
        if (type.equals(TYPE_BOTH)) {
            return DateFormat.getDateTimeInstance(this.calcStyle(this.getDateStyle()), this.calcStyle(this.getTimeStyle()), this.getLocale());
        }
        return null;
    }

    protected int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        return 2;
    }
}

