/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.MessageResourceBundleChainFactory;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.HTMLEncodeUtil;

public class FacesMessageUtil {
    private static final String DETAIL_SUFFIX = "_detail";
    private static final FacesMessage[] EMPTY_MESSAGES = new FacesMessage[0];

    private FacesMessageUtil() {
    }

    public static FacesMessage[] getWarnMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage.Severity severity = FacesMessage.SEVERITY_WARN;
        return FacesMessageUtil.getTargetFacesMessages(context, severity);
    }

    public static FacesMessage[] getInfoMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage.Severity severity = FacesMessage.SEVERITY_INFO;
        return FacesMessageUtil.getTargetFacesMessages(context, severity);
    }

    public static FacesMessage[] getErrorMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage.Severity severity = FacesMessage.SEVERITY_ERROR;
        return FacesMessageUtil.getTargetFacesMessages(context, severity);
    }

    public static FacesMessage[] getFatalMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage.Severity severity = FacesMessage.SEVERITY_FATAL;
        return FacesMessageUtil.getTargetFacesMessages(context, severity);
    }

    public static FacesMessage[] getTargetFacesMessages(FacesContext context, FacesMessage.Severity severity) {
        return FacesMessageUtil.getTargetFacesMessages(context, new FacesMessage.Severity[]{severity});
    }

    public static FacesMessage[] getAllMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        return FacesMessageUtil.getAllMessages(context);
    }

    public static FacesMessage[] getAllMessages(FacesContext context) {
        return FacesMessageUtil.getTargetFacesMessages(context, new FacesMessage.Severity[]{FacesMessage.SEVERITY_FATAL, FacesMessage.SEVERITY_ERROR, FacesMessage.SEVERITY_INFO, FacesMessage.SEVERITY_WARN});
    }

    public static FacesMessage[] getTargetFacesMessages(FacesContext context, FacesMessage.Severity[] severities) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (severities == null || severities.length == 0) {
            return EMPTY_MESSAGES;
        }
        Iterator it = context.getMessages();
        if (!it.hasNext()) {
            return EMPTY_MESSAGES;
        }
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        while (it.hasNext()) {
            FacesMessage facesMessage = (FacesMessage)it.next();
            FacesMessage.Severity severity = facesMessage.getSeverity();
            for (int i = 0; i < severities.length; ++i) {
                if (!severity.equals(severities[i])) continue;
                list.add(facesMessage);
            }
        }
        if (list.size() == 0) {
            return EMPTY_MESSAGES;
        }
        return list.toArray(new FacesMessage[list.size()]);
    }

    public static void addWarnMessage(String messageId) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addWarnComponentMessage(context, null, messageId);
    }

    public static void addWarnMessage(String messageId, Object[] args) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addWarnComponentMessage(context, null, messageId, args);
    }

    public static void addWarnComponentMessage(FacesContext context, UIComponent component, String messageId) {
        FacesMessageUtil.addWarnComponentMessage(context, component, messageId, null);
    }

    public static void addWarnComponentMessage(FacesContext context, UIComponent component, String messageId, Object[] args) {
        FacesMessageUtil.addTargetSeverityMessage(context, component, messageId, args, FacesMessage.SEVERITY_WARN);
    }

    public static void addInfoMessage(String messageId) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addInfoComponentMessage(context, null, messageId);
    }

    public static void addInfoMessage(String messageId, Object[] args) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addInfoComponentMessage(context, null, messageId, args);
    }

    public static void addInfoComponentMessage(FacesContext context, UIComponent component, String messageId) {
        FacesMessageUtil.addInfoComponentMessage(context, component, messageId, null);
    }

    public static void addInfoComponentMessage(FacesContext context, UIComponent component, String messageId, Object[] args) {
        FacesMessageUtil.addTargetSeverityMessage(context, component, messageId, args, FacesMessage.SEVERITY_INFO);
    }

    public static void addErrorMessage(String messageId) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addErrorComponentMessage(context, null, messageId);
    }

    public static void addErrorMessage(String messageId, Object[] args) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addErrorComponentMessage(context, null, messageId, args);
    }

    public static void addErrorComponentMessage(FacesContext context, UIComponent component, String messageId) {
        FacesMessageUtil.addErrorComponentMessage(context, component, messageId, null);
    }

    public static void addErrorComponentMessage(FacesContext context, UIComponent component, String messageId, Object[] args) {
        FacesMessageUtil.addTargetSeverityMessage(context, component, messageId, args, FacesMessage.SEVERITY_ERROR);
    }

    public static void addFatalMessage(String messageId) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addFatalComponentMessage(context, null, messageId);
    }

    public static void addFatalMessage(String messageId, Object[] args) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessageUtil.addFatalComponentMessage(context, null, messageId, args);
    }

    public static void addFatalComponentMessage(FacesContext context, UIComponent component, String messageId) {
        FacesMessageUtil.addFatalComponentMessage(context, component, messageId, null);
    }

    public static void addFatalComponentMessage(FacesContext context, UIComponent component, String messageId, Object[] args) {
        FacesMessageUtil.addTargetSeverityMessage(context, component, messageId, args, FacesMessage.SEVERITY_FATAL);
    }

    private static void addTargetSeverityMessage(FacesContext context, UIComponent component, String messageId, Object[] args, FacesMessage.Severity severity) {
        String clientId = component != null ? component.getClientId(context) : null;
        Locale locale = ComponentUtil_.getLocale(context);
        FacesMessage message = FacesMessageUtil.getMessage(context, locale, severity, messageId, args);
        context.addMessage(clientId, message);
    }

    public static String getSummary(FacesContext context, String messageId, Object[] args) {
        FacesMessage message = FacesMessageUtil.getMessage(context, messageId, args);
        return message != null ? message.getSummary() : null;
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] args) {
        Locale locale = ComponentUtil_.getLocale(context);
        return FacesMessageUtil.getMessage(context, locale, FacesMessage.SEVERITY_ERROR, messageId, args);
    }

    public static FacesMessage getMessage(FacesContext context, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageResourceBundle bundle = FacesMessageUtil.getBundle(context, locale);
        String summary = bundle.get(messageId);
        String detail = bundle.get(messageId + DETAIL_SUFFIX);
        if (summary == null) {
            MessageResourceBundle defaultBundle = FacesMessageUtil.getDefaultBundle(context, locale);
            summary = defaultBundle.get(messageId);
            if (summary != null) {
                detail = defaultBundle.get(messageId + DETAIL_SUFFIX);
            } else {
                detail = bundle.get(messageId + DETAIL_SUFFIX);
                if (detail == null) {
                    detail = defaultBundle.get(messageId + DETAIL_SUFFIX);
                }
            }
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o == null || !(o instanceof String)) continue;
                args[i] = HTMLEncodeUtil.encodeAll(o.toString());
            }
        }
        if (summary != null) {
            summary = FacesMessageUtil.getFormattedMessage(summary, locale, args);
        }
        if (detail != null) {
            detail = FacesMessageUtil.getFormattedMessage(detail, locale, args);
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static MessageResourceBundle getBundle(FacesContext context, Locale locale) {
        MessageResourceBundle bundle = null;
        String appBundleName = context.getApplication().getMessageBundle();
        if (appBundleName != null) {
            bundle = FacesMessageUtil.getBundle(context, locale, appBundleName);
        }
        if (bundle == null) {
            bundle = FacesMessageUtil.getDefaultBundle(context, locale);
        }
        return bundle;
    }

    private static MessageResourceBundle getDefaultBundle(FacesContext context, Locale locale) {
        return FacesMessageUtil.getBundle(context, locale, "javax.faces.Messages");
    }

    private static MessageResourceBundle getBundle(FacesContext context, Locale locale, String bundleName) {
        return MessageResourceBundleChainFactory.createChain(bundleName, locale);
    }

    private static String getFormattedMessage(String message, Locale locale, Object[] args) {
        if (args == null || args.length == 0) {
            return message;
        }
        return new MessageFormat(message, locale).format(args);
    }

    public static boolean hasClientId(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        String clientId = component.getClientId(context);
        Iterator itr = context.getClientIdsWithMessages();
        while (itr.hasNext()) {
            String cId = (String)itr.next();
            if (!clientId.equals(cId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMessagesByClientId(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        String clientId = component.getClientId(context);
        return FacesMessageUtil.hasMessagesByClientId(context, clientId);
    }

    public static boolean hasMessagesByClientId(FacesContext context, String clientId) {
        Iterator itr = context.getMessages(clientId);
        return itr.hasNext();
    }

    public static boolean hasMessages(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Iterator itr = context.getMessages();
        return itr.hasNext();
    }

    public static boolean hasErrorOrFatalMessage(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        FacesMessage[] allMessages = FacesMessageUtil.getAllMessages(context);
        for (int i = 0; i < allMessages.length; ++i) {
            FacesMessage fm = allMessages[i];
            FacesMessage.Severity severity = fm.getSeverity();
            if (!severity.equals(FacesMessage.SEVERITY_ERROR) && !severity.equals(FacesMessage.SEVERITY_FATAL)) continue;
            return true;
        }
        return false;
    }
}

