/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.teeda.core.render.html.support.UrlParameter;

public class UrlBuilder {
    private String base;
    private final Map urlParameters = new LinkedHashMap(){
        private static final long serialVersionUID = 1L;

        public Object get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                return value;
            }
            UrlParameter p = new UrlParameter();
            p.setKey((String)key);
            this.put(key, p);
            return p;
        }
    };

    public void setBase(String base) {
        this.base = base;
    }

    public String build() {
        StringBuffer sb = new StringBuffer(100);
        URI uri = URI.create(this.base);
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme());
            sb.append(":");
        }
        if (uri.getAuthority() != null) {
            sb.append("//");
            sb.append(uri.getAuthority());
        }
        if (uri.getPath() != null) {
            sb.append(uri.getPath());
        } else if (uri.getSchemeSpecificPart() != null) {
            sb.append(uri.getSchemeSpecificPart());
        }
        boolean questionAppeared = false;
        if (uri.getQuery() != null) {
            questionAppeared = true;
            sb.append('?');
            sb.append(uri.getQuery());
        }
        Iterator it = this.urlParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            UrlParameter parameter = (UrlParameter)entry.getValue();
            String[] values = parameter.getValues();
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (questionAppeared) {
                    sb.append('&');
                } else {
                    sb.append('?');
                    questionAppeared = true;
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
            }
        }
        if (uri.getFragment() != null) {
            sb.append('#');
            sb.append(uri.getFragment());
        }
        return new String(sb);
    }

    public void add(String key, String value) {
        UrlParameter p = (UrlParameter)this.urlParameters.get(key);
        p.addValue(value);
    }

    public String getBase() {
        return this.base;
    }

    public Map getUrlParameters() {
        return this.urlParameters;
    }
}

