/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.EnumerationIterator;
import org.seasar.framework.util.MethodUtil;
import org.seasar.teeda.core.resolver.RedirectUrlResolver;
import org.seasar.teeda.core.util.DIContainerUtil;

public class ServletExternalContextUtil {
    private static Logger logger = Logger.getLogger((Class)ServletExternalContextUtil.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_HEADER = "charset=";
    private static final int CHARSET_HEADER_LENGTH = "charset=".length();

    private ServletExternalContextUtil() {
    }

    public static void setCharacterEncoding(ServletRequest request) {
        Method characterEncodingMethod = ServletExternalContextUtil.getCharacterEncodingMethodFromRequest();
        if (characterEncodingMethod == null) {
            return;
        }
        if (!ServletExternalContextUtil.isHttpServletRequest(request)) {
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String contentType = httpServletRequest.getHeader(CONTENT_TYPE);
        String encoding = ServletExternalContextUtil.getEncodingFromContentType(contentType);
        if (encoding == null) {
            encoding = ServletExternalContextUtil.getEncodingFromSession(httpServletRequest);
        }
        if (encoding == null) {
            return;
        }
        MethodUtil.invoke((Method)characterEncodingMethod, (Object)httpServletRequest, (Object[])new Object[]{encoding});
    }

    public static boolean setCharacterEncoding(ServletResponse response) {
        Method characterEncodingMethod = ServletExternalContextUtil.getCharacterEncodingMethodFromResponse();
        if (characterEncodingMethod == null && !ServletExternalContextUtil.isHttpServletResponse(response)) {
            return false;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String contentType = httpServletResponse.getContentType();
        String encoding = ServletExternalContextUtil.getEncodingFromContentType(contentType);
        if (encoding == null) {
            return false;
        }
        MethodUtil.invoke((Method)characterEncodingMethod, (Object)httpServletResponse, (Object[])new Object[]{encoding});
        return true;
    }

    public static boolean isHttpServletRequest(ServletRequest request) {
        return request != null && request instanceof HttpServletRequest;
    }

    public static boolean isHttpServletResponse(ServletResponse response) {
        return response != null && response instanceof HttpServletResponse;
    }

    public static String getEncodingFromContentType(String contentType) {
        char charBefore;
        if (contentType == null) {
            return null;
        }
        String encoding = null;
        int found = contentType.indexOf(CHARSET_HEADER);
        if (found == 0) {
            encoding = contentType.substring(CHARSET_HEADER_LENGTH);
        } else if (found >= 1 && ((charBefore = contentType.charAt(found - 1)) == ';' || Character.isWhitespace(charBefore))) {
            encoding = contentType.substring(found + CHARSET_HEADER_LENGTH);
        }
        return encoding;
    }

    public static String getEncodingFromSession(HttpServletRequest servletRequest) {
        String encoding = null;
        HttpSession session = servletRequest.getSession(false);
        if (session != null) {
            encoding = (String)session.getAttribute("javax.faces.request.charset");
        }
        return encoding;
    }

    public static void dispatch(String path, ServletRequest request, ServletResponse response) throws IOException {
        AssertionUtil.assertNotNull((String)"path is null.", (Object)path);
        RequestDispatcher dispatcher = request.getRequestDispatcher(path);
        try {
            dispatcher.forward(request, response);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), e);
            }
            throw new FacesException(e);
        }
    }

    public static Iterator getLocales(Enumeration locales) {
        return new EnumerationIterator(locales);
    }

    public static Iterator getRequestParameterNames(Enumeration paramNames) {
        return new EnumerationIterator(paramNames);
    }

    public static void redirect(String url, ServletRequest request, ServletResponse response) throws IOException {
        RedirectUrlResolver resolver;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        FacesContext context = FacesContext.getCurrentInstance();
        if (DIContainerUtil.hasContainer() && (resolver = (RedirectUrlResolver)DIContainerUtil.getComponentNoException(RedirectUrlResolver.class)) != null) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            url = resolver.resolveUrl(url, context, httpRequest, httpResponse);
        }
        httpResponse.sendRedirect(url);
        if (context != null) {
            context.responseComplete();
        } else {
            logger.info((Object)"[ServletExternalContextUtil.redirect] facesContext is null.");
        }
    }

    private static Method getCharacterEncodingMethodFromRequest() {
        try {
            Class clazz = ServletRequest.class;
            return clazz.getMethod("setCharacterEncoding", String.class);
        }
        catch (Exception e) {
            logger.log((Throwable)e);
            return null;
        }
    }

    private static Method getCharacterEncodingMethodFromResponse() {
        try {
            Class clazz = ServletResponse.class;
            return clazz.getMethod("setCharacterEncoding", String.class);
        }
        catch (Exception e) {
            logger.log((Throwable)e);
            return null;
        }
    }

    public static HttpServletRequest getRequest(ExternalContext externalContext) {
        return (HttpServletRequest)externalContext.getRequest();
    }

    public static HttpServletResponse getResponse(ExternalContext externalContext) {
        return (HttpServletResponse)externalContext.getResponse();
    }

    public static boolean isGet(ExternalContext externalContext) {
        return ServletExternalContextUtil.getRequest(externalContext).getMethod().equals("GET");
    }

    public static boolean isPost(ExternalContext externalContext) {
        return ServletExternalContextUtil.getRequest(externalContext).getMethod().equals("POST");
    }

    public static void storeErrorInfoToAttribute(ServletRequest request, Throwable exception) {
        AssertionUtil.assertNotNull((String)"request", (Object)request);
        AssertionUtil.assertNotNull((String)"exception", (Object)exception);
        request.setAttribute("teeda.jsf.error.exception", (Object)exception);
        request.setAttribute("teeda.jsf.error.exception_type", exception.getClass());
        request.setAttribute("teeda.jsf.error.message", (Object)exception.getMessage());
    }
}

