/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.webapp;

import java.io.InputStream;
import javax.faces.internal.ConverterBuilder;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.HotDeployConverterBuilderImpl;
import javax.faces.internal.HotDeployValidatorBuilderImpl;
import javax.faces.internal.NormalConverterBuilderImpl;
import javax.faces.internal.NormalValidatorBuilderImpl;
import javax.faces.internal.ValidatorBuilder;
import javax.faces.internal.ValidatorResource;
import javax.servlet.ServletContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.config.faces.FacesConfigBuilder;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.webapp.WebappConfigBuilder;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ServletContextUtil;

public class TeedaInitializer {
    private ServletContext servletContext;

    public void initializeFaces() {
        ServletContext context = this.getServletContext();
        if (context == null) {
            throw new IllegalStateException("servletContext must not be null.");
        }
        this.initializeFacesConfigOptions(context);
        this.initializeFacesConfigCustomOptions(context);
        this.buildFacesConfig();
        this.buildWebAppConfig(context);
        this.buildResources();
    }

    protected void buildResources() {
        S2Container container = DIContainerUtil.getContainer();
        ValidatorBuilder validatorBuilder = (ValidatorBuilder)DIContainerUtil.getComponentNoException(ValidatorBuilder.class);
        if (validatorBuilder == null) {
            validatorBuilder = HotdeployUtil.isHotdeploy() ? new HotDeployValidatorBuilderImpl(container) : new NormalValidatorBuilderImpl(container);
        }
        ValidatorResource.setValidatorBuilder(validatorBuilder);
        ConverterBuilder converterBuilder = (ConverterBuilder)DIContainerUtil.getComponentNoException(ConverterBuilder.class);
        if (converterBuilder == null) {
            converterBuilder = HotdeployUtil.isHotdeploy() ? new HotDeployConverterBuilderImpl(container) : new NormalConverterBuilderImpl(container);
        }
        ConverterResource.setConverterBuilder(converterBuilder);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String getInitParameter(ServletContext context, String key) {
        return context.getInitParameter(key);
    }

    protected void initializeFacesConfigOptions(ServletContext servletContext) {
        String defaultLayoutPath;
        String defaultGridAsync;
        String suffix;
        String configFilesAttr = this.getInitParameter(servletContext, "javax.faces.CONFIG_FILES");
        FacesConfigOptions.setConfigFiles(configFilesAttr);
        String savingMethod = this.getInitParameter(servletContext, "javax.faces.STATE_SAVING_METHOD");
        if (savingMethod != null) {
            FacesConfigOptions.setSavingStateInClient("client".equalsIgnoreCase(savingMethod));
        }
        if ((suffix = this.getInitParameter(servletContext, "javax.faces.DEFAULT_SUFFIX")) != null) {
            FacesConfigOptions.setDefaultSuffix(suffix);
        } else {
            FacesConfigOptions.setDefaultSuffix(".jsp");
        }
        String lifecycleId = this.getInitParameter(servletContext, "javax.faces.LIFECYCLE_ID");
        if (lifecycleId != null) {
            FacesConfigOptions.setLifecycleId(lifecycleId);
        }
        if ((defaultGridAsync = this.getInitParameter(servletContext, "teeda.DEFAULT_GRID_ASYNC")) != null) {
            FacesConfigOptions.setDefaultGridAsync(Boolean.valueOf(defaultGridAsync));
        }
        if ((defaultLayoutPath = this.getInitParameter(servletContext, "teeda.DEFAULT_LAYOUT_PATH")) != null) {
            FacesConfigOptions.setDefaultLayoutPath(defaultLayoutPath);
        }
    }

    protected void initializeFacesConfigCustomOptions(ServletContext servletContext) {
        String redirectUrl;
        String compressState;
        String javaScriptNotPermittedPath = this.getInitParameter(servletContext, "teeda.JAVASCRIPT_NOT_PERMITTED_PATH");
        if (javaScriptNotPermittedPath != null) {
            String[] paths = StringUtil.split((String)javaScriptNotPermittedPath, (String)",");
            FacesConfigOptions.setJavascriptNotPermittedPath(paths);
        }
        if ((compressState = this.getInitParameter(servletContext, "javax.faces.COMPRESS_STATE")) != null) {
            FacesConfigOptions.setCompressState(compressState.equalsIgnoreCase("true"));
        }
        if ((redirectUrl = this.getInitParameter(servletContext, "teeda.REDIRECT_URL")) != null) {
            FacesConfigOptions.setRedirectUrl(redirectUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildWebAppConfig(ServletContext servletContext) {
        WebappConfigBuilder webAppConfigBuilder = (WebappConfigBuilder)DIContainerUtil.getComponent(WebappConfigBuilder.class);
        InputStream is = null;
        WebappConfig webappConfig = null;
        try {
            is = ServletContextUtil.getResourceAsStream(servletContext, "/WEB-INF/web.xml");
            webappConfig = webAppConfigBuilder.build(is, "/WEB-INF/web.xml");
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
        servletContext.setAttribute(WebappConfig.class.getName(), (Object)webappConfig);
    }

    protected void buildFacesConfig() {
        FacesConfigBuilder facesConfigBuilder = (FacesConfigBuilder)DIContainerUtil.getComponent(FacesConfigBuilder.class);
        FacesConfig facesConfig = facesConfigBuilder.buildFacesConfigs();
        AssemblerAssembler assembler = (AssemblerAssembler)DIContainerUtil.getComponent(AssemblerAssembler.class);
        assembler.assembleFactories(facesConfig);
        assembler.assembleApplication(facesConfig);
        assembler.assembleManagedBeans(facesConfig);
        assembler.assmbleNavigationRules(facesConfig);
        assembler.assembleLifecycle(facesConfig);
        assembler.assembleRenderKits(facesConfig);
    }
}

